/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestPrefixMap {
    protected abstract PrefixMap getPrefixMap();

    @Test
    public void prefixMap_basic_01() {
        PrefixMap pmap = this.getPrefixMap();
        Assert.assertTrue((boolean)pmap.isEmpty());
        Assert.assertEquals((long)0L, (long)pmap.size());
        Assert.assertTrue((boolean)pmap.getMapping().isEmpty());
        Assert.assertTrue((boolean)pmap.getMappingCopy().isEmpty());
    }

    @Test
    public void prefixMap_basic_02() {
        PrefixMap pmap = this.getPrefixMap();
        pmap.add("", "http://example/");
        Assert.assertFalse((boolean)pmap.isEmpty());
        Assert.assertEquals((long)1L, (long)pmap.size());
        Assert.assertTrue((boolean)pmap.containsPrefix(""));
        Assert.assertTrue((boolean)pmap.getMapping().containsKey(""));
        Assert.assertTrue((boolean)pmap.getMappingCopy().containsKey(""));
    }

    @Test
    public void prefixMap_basic_03() {
        PrefixMap pmap = this.getPrefixMap();
        pmap.add("", "http://example/");
        pmap.add("org", "http://example.org/");
        Assert.assertTrue((boolean)pmap.containsPrefix(""));
        Assert.assertTrue((boolean)pmap.containsPrefix("org"));
        Assert.assertFalse((boolean)pmap.isEmpty());
        Assert.assertEquals((long)2L, (long)pmap.size());
    }

    @Test
    public void prefixMap_basic_04() {
        PrefixMap pmap1 = this.getPrefixMap();
        pmap1.add("", "http://example/");
        pmap1.add("org", "http://example.org/");
        PrefixMap pmap2 = this.getPrefixMap();
        pmap2.putAll(pmap1);
        Assert.assertTrue((boolean)pmap2.containsPrefix(""));
        Assert.assertTrue((boolean)pmap2.containsPrefix("org"));
        Assert.assertFalse((boolean)pmap2.isEmpty());
        Assert.assertEquals((long)2L, (long)pmap2.size());
    }

    @Test
    public void prefixMap_expand_01() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "", "http://example/");
        String x = pmap.expand("", "x");
        Assert.assertEquals((Object)"http://example/x", (Object)x);
    }

    @Test
    public void prefixMap_expand_02() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        String x = pmap.expand("", "x");
        Assert.assertNull((Object)x);
    }

    @Test
    public void prefixMap_expand_03() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        this.add(pmap, "ex", "http://example/");
        String x = pmap.expand("", "x");
        Assert.assertNull((Object)x);
    }

    @Test
    public void prefixMap_expand_04() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        this.add(pmap, "ex", "http://elsewhere/ns#");
        String x = pmap.expand("ex", "x");
        Assert.assertEquals((Object)"http://elsewhere/ns#x", (Object)x);
    }

    @Test
    public void prefixMap_delete_01() {
        PrefixMap pmap = this.getPrefixMap();
        pmap.delete("ex");
    }

    @Test
    public void prefixMap_delete_02() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        String x = pmap.expand("ex", "x");
        Assert.assertEquals((Object)"http://example/x", (Object)x);
        pmap.delete("ex");
        x = pmap.expand("ex", "x");
        Assert.assertNull((Object)x);
    }

    @Test
    public void prefixMap_abbrev_01() {
        PrefixMap pmap = this.getPrefixMap();
        String x = pmap.abbreviate("http://example/x");
        Assert.assertNull((Object)x);
    }

    @Test
    public void prefixMap_abbrev_02() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://elsewhere/ns#");
        String x = pmap.abbreviate("http://example/x");
        Assert.assertNull((Object)x);
    }

    @Test
    public void prefixMap_abbrev_03() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        this.add(pmap, "eg", "http://elsewhere/ns#");
        String x = pmap.abbreviate("http://example/x");
        Assert.assertEquals((Object)"ex:x", (Object)x);
    }

    @Test
    public void prefixMap_abbrev_04() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        this.add(pmap, "eg", "http://example/ns#");
        String x = pmap.abbreviate("http://example/x");
        Assert.assertEquals((Object)"ex:x", (Object)x);
    }

    @Test
    public void prefixMap_abbrev_05() {
        PrefixMap pmap = this.getPrefixMap();
        this.add(pmap, "ex", "http://example/");
        this.add(pmap, "eg", "http://example/");
        String x = pmap.abbreviate("http://example/x");
        Assert.assertNotNull((Object)x);
        Assert.assertTrue((x.equals("ex:x") || x.equals("eg:x") ? 1 : 0) != 0);
    }

    @Test
    public void prefixMap_abbrev_06() {
        PrefixMap pmap = this.getPrefixMap();
        for (int i = 1; i <= 100; ++i) {
            this.add(pmap, "ns" + i, "http://example/ns" + i + "#");
        }
        String x = pmap.abbreviate("http://example/ns100#x");
        Assert.assertEquals((Object)"ns100:x", (Object)x);
    }

    protected PrefixMap create() {
        PrefixMap pm = this.getPrefixMap();
        pm.add("p0", "http://example/a/");
        pm.add("p1", "http://example/a/b");
        pm.add("p2", "http://example/a/b/");
        pm.add("p3", "http://example/a/b#");
        pm.add("q1", "http://example/a");
        pm.add("q2", "http://example/a#");
        return pm;
    }

    @Test
    public void prefixMap_abbrev_10() {
        this.pmTest("http://example/a/b", "p1:", "p0:b");
    }

    @Test
    public void prefixMap_abbrev_11() {
        this.pmTest("http://example/a/bcd", "p1:cd", "p0:bcd");
    }

    @Test
    public void prefixMap_abbrev_12() {
        this.pmTest("http://example/a/b/c", "p2:c");
    }

    @Test
    public void prefixMap_abbrev_13() {
        this.pmTest("http://example/a/b/c/", new String[0]);
    }

    @Test
    public void prefixMap_abbrev_14() {
        this.pmTest("http://example/a/b/c/d", new String[0]);
    }

    @Test
    public void prefixMap_abbrev_15() {
        this.pmTest("http://example/a/b#x", "p3:x");
    }

    @Test
    public void prefixMap_abbrev_16() {
        this.pmTest("http://example/a#z", "q2:z");
    }

    @Test
    public void prefixMap_abbrev_17() {
        this.pmTest("http://example/a/", "p0:");
    }

    @Test
    public void prefixMap_abbrev_18() {
        this.pmTest("http://example/a", "q1:");
    }

    @Test
    public void prefixMap_abbrev_20() {
        PrefixMap pmap = PrefixMapFactory.create();
        pmap.add("ex", "http://example/");
        pmap.delete("ex");
        String x = pmap.abbreviate("http://example/s");
        Assert.assertNull((Object)x);
    }

    public void pmTest(String iriStr, String ... expected) {
        PrefixMap pm = this.create();
        String x = pm.abbreviate(iriStr);
        if (expected.length == 0) {
            Assert.assertNull((String)("expected no abbreviation for " + iriStr), (Object)x);
            return;
        }
        for (String possible : expected) {
            if (!possible.equals(x)) continue;
            return;
        }
        Assert.fail((String)("Expected one of " + String.join((CharSequence)" , ", expected) + " but got " + x));
    }

    protected void add(PrefixMap pmap, String prefix, String uri) {
        pmap.add(prefix, uri);
    }
}

