/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.stream;

import java.util.Iterator;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.util.LocationMapper;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLocationMapper {
    static Logger log = LoggerFactory.getLogger(TestLocationMapper.class);
    static final String testingDir = "testing/RIOT/FileManager";
    static final String filename1 = "file:test";
    static final String notFilename = "zzzz";
    static final String filename2 = "file:testing/RIOT/FileManager/location-mapping-test-file";
    public static final String mapping = "location-mapping-test.ttl;testing/RIOT/FileManager/location-mapping-test.ttl";

    @Test
    public void testLocationMapper() {
        LocationMapper locMap = new LocationMapper(mapping);
        String alt2 = locMap.altMapping(filename1);
        Assert.assertNotNull((Object)alt2);
        Assert.assertEquals((Object)filename2, (Object)alt2);
    }

    @Test
    public void testLocationMapperMiss() {
        LocationMapper locMap = new LocationMapper(mapping);
        String alt2 = locMap.altMapping(notFilename);
        Assert.assertNotNull((Object)alt2);
        Assert.assertEquals((Object)notFilename, (Object)alt2);
    }

    @Test
    public void testLocationMapperURLtoFile() {
        LocationMapper locMap = new LocationMapper(mapping);
        String alt2 = locMap.altMapping("http://example.org/file");
        Assert.assertNotNull((Object)alt2);
        Assert.assertEquals((Object)filename2, (Object)alt2);
    }

    @Test
    public void testLocationMapperFromModel() {
        String v2;
        String v1;
        String e2;
        Model model = RDFDataMgr.loadModel("testing/RIOT/FileManager/location-mapping-test.ttl");
        LocationMapper loc = new LocationMapper(model);
        LocationMapper locMap = new LocationMapper(mapping);
        Iterator<String> iter = loc.listAltEntries();
        while (iter.hasNext()) {
            e2 = iter.next();
            v1 = locMap.getAltEntry(e2);
            v2 = loc.getAltEntry(e2);
            Assert.assertEquals((String)"Different entries", (Object)v1, (Object)v2);
        }
        iter = loc.listAltPrefixes();
        while (iter.hasNext()) {
            e2 = iter.next();
            v1 = locMap.getAltPrefix(e2);
            v2 = loc.getAltPrefix(e2);
            Assert.assertEquals((String)"Different entries", (Object)v1, (Object)v2);
        }
    }

    @Test
    public void testLocationMapperClone1() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(locMap1);
        locMap1.removeAltEntry("http://example.org/file");
        String alt2 = locMap2.altMapping("http://example.org/file");
        Assert.assertNotNull((Object)alt2);
        Assert.assertEquals((Object)filename2, (Object)alt2);
    }

    @Test
    public void testLocationMapperClone2() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(locMap1);
        locMap2.addAltPrefix("http://example.org/OTHER", "file:OTHER");
        String alt2 = locMap2.altMapping("http://example.org/OTHER/f");
        Assert.assertNotNull((Object)alt2);
        Assert.assertEquals((Object)"file:OTHER/f", (Object)alt2);
        alt2 = locMap1.altMapping("http://example.org/OTHER/f");
        Assert.assertNotNull((Object)alt2);
        Assert.assertEquals((Object)"http://example.org/OTHER/f", (Object)alt2);
    }

    @Test
    public void testLocationMapperEquals1() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(mapping);
        Assert.assertEquals((Object)locMap1, (Object)locMap2);
        Assert.assertEquals((long)locMap1.hashCode(), (long)locMap2.hashCode());
    }

    @Test
    public void testLocationMapperEquals2() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(mapping);
        locMap2.addAltEntry("file:nowhere", "file:somewhere");
        Assert.assertFalse((boolean)locMap1.equals(locMap2));
        Assert.assertFalse((boolean)locMap2.equals(locMap1));
    }

    @Test
    public void testLocationMapperToModel1() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(locMap1.toModel());
        Assert.assertEquals((Object)locMap1, (Object)locMap2);
        Assert.assertEquals((long)locMap1.hashCode(), (long)locMap2.hashCode());
    }

    @Test
    public void testLocationMapperToModel2() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(mapping);
        locMap1 = new LocationMapper(locMap1.toModel());
        locMap2.addAltEntry("file:nowhere", "file:somewhere");
        Assert.assertFalse((boolean)locMap1.equals(locMap2));
        Assert.assertFalse((boolean)locMap2.equals(locMap1));
    }
}

