/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderResultSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestResultSetIO {
    static String rsStr = StrUtils.strjoinNL("(resultset (?x ?y)", "   (row (?x _:b0) (?y _:b1))", "   (row (?x _:b2) (?y _:b3))", "   (row (?x _:b1) (?y _:b0))", "   (row (?x 1)           )", "   (row           (?y 2) )", "   (row )", ")");
    static ResultSetRewindable test_rs = ResultSetFactory.makeRewindable(BuilderResultSet.build(SSE.parse(rsStr)));
    private final Lang lang;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        Lang[] langs = new Lang[]{ResultSetLang.RS_XML, ResultSetLang.RS_JSON, ResultSetLang.RS_CSV, ResultSetLang.RS_TSV};
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        for (Lang lang : langs) {
            x.add(new Object[]{"test:" + lang.getName(), lang});
        }
        return x;
    }

    @Before
    public void beforetest() {
        test_rs.reset();
    }

    public TestResultSetIO(String name, Lang lang) {
        this.lang = lang;
    }

    @Test
    public void test_resultset_01() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ResultSetMgr.write((OutputStream)out, test_rs, this.lang);
        test_rs.reset();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs = ResultSetMgr.read(in, this.lang);
        ResultSetRewindable rsw = ResultSetFactory.makeRewindable(rs);
        if (!this.lang.equals(ResultSetLang.RS_CSV)) {
            Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(test_rs, rsw));
        }
        rsw.reset();
        test_rs.reset();
        out = new ByteArrayOutputStream();
        ResultSetMgr.write((OutputStream)out, rsw, this.lang);
        in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs2 = ResultSetMgr.read(in, this.lang);
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rsw, rs2));
    }
}

