/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import org.apache.jena.atlas.io.StringWriterI;
import org.apache.jena.riot.out.quoted.QuotedStringOutput;
import org.apache.jena.riot.out.quoted.QuotedStringOutputNT;
import org.apache.jena.riot.out.quoted.QuotedStringOutputTTL;
import org.apache.jena.riot.out.quoted.QuotedStringOutputTTL_MultiLine;
import org.junit.Assert;
import org.junit.Test;

public class TestQuotedStringOutput {
    private QuotedStringOutput escProcNT = new QuotedStringOutputNT();
    private QuotedStringOutput escProcTTL_S2 = new QuotedStringOutputTTL('\"');
    private QuotedStringOutput escProcTTL_S1 = new QuotedStringOutputTTL('\'');
    private QuotedStringOutput escProcTTL_M2 = new QuotedStringOutputTTL_MultiLine('\"');
    private QuotedStringOutput escProcTTL_M1 = new QuotedStringOutputTTL_MultiLine('\'');

    static void testSingleLine(QuotedStringOutput proc, String input, String expected) {
        StringWriterI w = new StringWriterI();
        proc.writeStr(w, input);
        String output = w.toString();
        expected = proc.getQuoteChar() + (String)expected + proc.getQuoteChar();
        Assert.assertEquals((Object)expected, (Object)output);
    }

    static void testMultiLine(QuotedStringOutput proc, String input, String expected) {
        StringWriterI w = new StringWriterI();
        proc.writeStrMultiLine(w, input);
        String output = w.toString();
        Assert.assertEquals((Object)expected, (Object)output);
    }

    @Test
    public void escape_nt_00() {
        TestQuotedStringOutput.testSingleLine(this.escProcNT, "", "");
    }

    @Test
    public void escape_nt_01() {
        TestQuotedStringOutput.testSingleLine(this.escProcNT, "abc", "abc");
    }

    @Test
    public void escape_nt_02() {
        TestQuotedStringOutput.testSingleLine(this.escProcNT, "abc\ndef", "abc\\ndef");
    }

    @Test
    public void escape_nt_03() {
        TestQuotedStringOutput.testSingleLine(this.escProcNT, "\"", "\\\"");
    }

    @Test
    public void escape_nt_04() {
        TestQuotedStringOutput.testSingleLine(this.escProcNT, "'", "'");
    }

    @Test
    public void escape_nt_05() {
        TestQuotedStringOutput.testSingleLine(this.escProcNT, "xyz\t", "xyz\\t");
    }

    @Test
    public void escape_ttl_singleline_quote2_00() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S2, "", "");
    }

    @Test
    public void escape_ttl_singleline_quote2_01() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S2, "abc", "abc");
    }

    @Test
    public void escape_ttl_singleline_quote2_02() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S2, "abc\ndef", "abc\\ndef");
    }

    @Test
    public void escape_ttl_singleline_quote2_03() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S2, "\"", "\\\"");
    }

    @Test
    public void escape_ttl_singleline_quote2_04() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S2, "'", "'");
    }

    @Test
    public void escape_ttl_singleline_quote2_05() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S2, "xyz\t", "xyz\\t");
    }

    @Test
    public void escape_ttl_singleline_quote1_00() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S1, "", "");
    }

    @Test
    public void escape_ttl_singleline_quote1_01() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S1, "abc", "abc");
    }

    @Test
    public void escape_ttl_singleline_quote1_02() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S1, "abc\ndef", "abc\\ndef");
    }

    @Test
    public void escape_ttl_singleline_quote1_03() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S1, "\"", "\"");
    }

    @Test
    public void escape_ttl_singleline_quote1_04() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S1, "'", "\\'");
    }

    @Test
    public void escape_ttl_singleline_quote1_05() {
        TestQuotedStringOutput.testSingleLine(this.escProcTTL_S1, "xyz\t", "xyz\\t");
    }

    @Test
    public void escape_ttl_singleline_quote2_multiline_str0() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S2, "", "\"\"");
    }

    @Test
    public void escape_ttl_singleline_quote2_multiline_str1() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S2, "abc", "\"abc\"");
    }

    @Test
    public void escape_ttl_singleline_quote2_multiline_str2() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S2, "abc\ndef", "\"abc\\ndef\"");
    }

    @Test
    public void escape_ttl_singleline_quote2_multiline_str3() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S2, "\"", "\"\\\"\"");
    }

    @Test
    public void escape_ttl_singleline_quote2_multiline_str4() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S2, "'", "\"'\"");
    }

    @Test
    public void escape_ttl_singleline_quote2_multiline_str5() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S2, "xyz\t", "\"xyz\\t\"");
    }

    @Test
    public void escape_ttl_singleline_quote1_multiline_str0() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S1, "", "''");
    }

    @Test
    public void escape_ttl_singleline_quote1_multiline_str1() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S1, "abc", "'abc'");
    }

    @Test
    public void escape_ttl_singleline_quote1_multiline_str2() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S1, "abc\ndef", "'abc\\ndef'");
    }

    @Test
    public void escape_ttl_singleline_quote1_multiline_str3() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S1, "\"", "'\"'");
    }

    @Test
    public void escape_ttl_singleline_quote1_multiline_str4() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S1, "'", "'\\''");
    }

    @Test
    public void escape_ttl_singleline_quote1_multiline_str5() {
        TestQuotedStringOutput.testMultiLine(this.escProcTTL_S1, "xyz\t", "'xyz\\t'");
    }
}

