/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeFmtLib {
    @Test
    public void encode_01() {
        this.testenc("abc", "Babc");
    }

    @Test
    public void encode_02() {
        this.testenc("-", "BX2D");
    }

    @Test
    public void encode_03() {
        this.testenc("abc:def-ghi", "BabcX3AdefX2Dghi");
    }

    @Test
    public void encode_04() {
        this.testenc("01X", "B01XX");
    }

    @Test
    public void encode_05() {
        this.testenc("-X", "BX2DXX");
    }

    @Test
    public void rt_01() {
        this.testencdec("a");
    }

    @Test
    public void rt_02() {
        this.testencdec("");
    }

    @Test
    public void rt_03() {
        this.testencdec("abc");
    }

    @Test
    public void rt_04() {
        this.testencdec("000");
    }

    @Test
    public void rt_05() {
        this.testencdec("-000");
    }

    @Test
    public void rt_06() {
        this.testencdec("X-");
    }

    @Test
    public void rt_07() {
        this.testencdec("-123:456:xyz");
    }

    private void testenc(String input, String expected) {
        String x = NodeFmtLib.encodeBNodeLabel(input);
        Assert.assertEquals((Object)expected, (Object)x);
    }

    private void testencdec(String input) {
        String x = NodeFmtLib.encodeBNodeLabel(input);
        String y = NodeFmtLib.decodeBNodeLabel(x);
        Assert.assertEquals((Object)input, (Object)y);
    }

    @Test
    public void fmtNode_01() {
        TestNodeFmtLib.test("<a>", "<a>");
    }

    @Test
    public void fmtNode_02() {
        TestNodeFmtLib.test("<" + RDF.getURI() + "type>", "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>");
    }

    @Test
    public void fmtNode_03() {
        TestNodeFmtLib.test("'123'^^xsd:integer", "\"123\"^^<http://www.w3.org/2001/XMLSchema#integer>");
    }

    @Test
    public void fmtNode_04() {
        TestNodeFmtLib.test("'abc'^^xsd:integer", "\"abc\"^^<http://www.w3.org/2001/XMLSchema#integer>");
    }

    @Test
    public void fmtNode_05() {
        TestNodeFmtLib.testDisplay("<" + RDF.getURI() + "type>", "rdf:type");
    }

    @Test
    public void fmtNode_06() {
        TestNodeFmtLib.testDisplay("'123'^^xsd:integer", "123");
    }

    @Test
    public void fmtNode_07() {
        TestNodeFmtLib.testDisplay("'abc'^^xsd:integer", "\"abc\"^^xsd:integer");
    }

    private static void test(String node, String output) {
        TestNodeFmtLib.test(NodeFactoryExtra.parseNode(node), output);
    }

    private static void test(Node node, String output) {
        String x = NodeFmtLib.str(node);
        Assert.assertEquals((Object)output, (Object)x);
    }

    private static void testDisplay(String node, String output) {
        TestNodeFmtLib.testDisplay(NodeFactoryExtra.parseNode(node), output);
    }

    private static void testDisplay(Node node, String output) {
        String x = NodeFmtLib.displayStr(node);
        Assert.assertEquals((Object)output, (Object)x);
    }
}

