/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.out.quoted.QuotedStringOutput;
import org.apache.jena.riot.out.quoted.QuotedStringOutputTTL_MultiLine;
import org.apache.jena.riot.system.PrefixMap;

public class NodeFormatterTTL_MultiLine
extends NodeFormatterTTL {
    private final QuotedStringOutput escapeProc2 = new QuotedStringOutputTTL_MultiLine('\"');
    private final QuotedStringOutput escapeProc1 = new QuotedStringOutputTTL_MultiLine('\'');
    private Runnable noop;

    private boolean writeAsMultiLine(AWriter w, String lex) {
        return lex.contains("\n");
    }

    public NodeFormatterTTL_MultiLine(String baseIRI, PrefixMap prefixMap) {
        super(baseIRI, prefixMap);
        this.noop = () -> {};
    }

    public NodeFormatterTTL_MultiLine(String baseIRI, PrefixMap prefixMap, NodeToLabel nodeToLabel) {
        super(baseIRI, prefixMap, nodeToLabel);
        this.noop = () -> {};
    }

    @Override
    public void formatLitString(AWriter w, String lex) {
        if (!this.writeAsMultiLine(w, lex)) {
            this.writeLexicalSingleLine(w, lex, this.noop);
            return;
        }
        this.writeLexicalMultiLine(w, lex, this.noop);
    }

    @Override
    public void formatLitLang(AWriter w, String lex, String langTag) {
        if (!this.writeAsMultiLine(w, lex)) {
            super.formatLitLang(w, lex, langTag);
            return;
        }
        this.writeLexicalMultiLine(w, lex, () -> {
            w.print('@');
            w.print(langTag);
        });
    }

    @Override
    protected void writeLiteralLongForm(AWriter w, String lex, String datatypeURI) {
        if (!this.writeAsMultiLine(w, lex)) {
            super.writeLiteralOneLine(w, lex, datatypeURI);
            return;
        }
        this.writeLexicalMultiLine(w, lex, () -> {
            w.print("^^");
            this.formatURI(w, datatypeURI);
        });
    }

    private QuotedStringOutput chooseEscapeProcessor(String str2) {
        QuotedStringOutput proc = this.escapeProc2;
        if (str2.indexOf(34) >= 0 && str2.indexOf(39) < 0) {
            proc = this.escapeProc1;
        }
        return proc;
    }

    private void writeLexicalSingleLine(AWriter writer, String str2, Runnable action) {
        QuotedStringOutput proc = this.chooseEscapeProcessor(str2);
        proc.writeStr(writer, str2);
    }

    private void writeLexicalMultiLine(AWriter writer, String str2, Runnable action) {
        QuotedStringOutput escapeProc = this.chooseEscapeProcessor(str2);
        int indent = -1;
        IndentedWriter iw = null;
        if (writer instanceof IndentedWriter) {
            iw = (IndentedWriter)writer;
            iw.pad();
            indent = iw.getAbsoluteIndent();
            iw.setAbsoluteIndent(0);
        }
        escapeProc.writeStrMultiLine(writer, str2);
        if (action != null) {
            action.run();
        }
        if (indent >= 0) {
            iw.setAbsoluteIndent(indent);
        }
    }
}

