/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.InputStream;
import java.util.Arrays;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.lang.ReaderTriX;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.util.IsoMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTriXReader {
    static String DIR = "testing/RIOT/Lang/TriX";
    @Parameterized.Parameter(value=0)
    public String fInput;
    @Parameterized.Parameter(value=1)
    public String fExpected;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({DIR + "/trix-01.trix", DIR + "/trix-01.nq"}, {DIR + "/trix-02.trix", DIR + "/trix-02.nq"}, {DIR + "/trix-03.trix", DIR + "/trix-03.nq"}, {DIR + "/trix-04.trix", DIR + "/trix-04.nq"}, {DIR + "/trix-05.trix", DIR + "/trix-05.nq"}, {DIR + "/trix-06.trix", DIR + "/trix-06.nq"}, {DIR + "/trix-10.trix", DIR + "/trix-10.nq"}, {DIR + "/trix-11.trix", DIR + "/trix-11.nq"}, {DIR + "/trix-12.trix", DIR + "/trix-12.nq"}, {DIR + "/trix-13.trix", DIR + "/trix-13.nq"}, {DIR + "/trix-14.trix", DIR + "/trix-14.nq"}, {DIR + "/trix-15.trix", DIR + "/trix-15.nq"}, {DIR + "/trix-ns-1.trix", DIR + "/trix-ns-1.nq"}, {DIR + "/trix-ns-2.trix", DIR + "/trix-ns-2.nq"}, {DIR + "/trix-ex-1.trix", null}, {DIR + "/trix-ex-3.trix", null}, {DIR + "/trix-ex-4.trix", null}, {DIR + "/trix-ex-5.trix", null}, {DIR + "/trix-w3c-1.trix", DIR + "/trix-w3c-1.nq"}, {DIR + "/trix-w3c-2.trix", DIR + "/trix-w3c-2.nq"}, {DIR + "/trix-star-1.trix", DIR + "/trix-star-1.nq"}, {DIR + "/trix-star-2.trix", DIR + "/trix-star-2.nq"});
    }

    @Test
    public void trix_direct() {
        DatasetGraph dsg2;
        boolean b;
        ReaderTriX r = new ReaderTriX(RiotLib.dftProfile(), ErrorHandlerFactory.errorHandlerNoWarnings);
        InputStream in = IO.openFile(this.fInput);
        DatasetGraph dsg = DatasetGraphFactory.create();
        StreamRDF stream = StreamRDFLib.dataset(dsg);
        stream.start();
        r.read(in, null, null, stream, null);
        stream.finish();
        if (this.fExpected != null && !(b = IsoMatcher.isomorphic(dsg, dsg2 = RDFDataMgr.loadDatasetGraph(this.fExpected)))) {
            Assert.fail((String)"Not isomorphic");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void trix_model() {
        Model m1 = null;
        Model m2 = null;
        ErrorHandler err = ErrorHandlerFactory.getDefaultErrorHandler();
        try {
            ErrorHandlerFactory.setDefaultErrorHandler(ErrorHandlerFactory.errorHandlerNoWarnings);
            m1 = RDFDataMgr.loadModel(this.fInput);
            if (this.fExpected != null) {
                m2 = RDFDataMgr.loadModel(this.fExpected);
            }
        }
        finally {
            ErrorHandlerFactory.setDefaultErrorHandler(err);
        }
        if (m2 != null) {
            Assert.assertTrue((String)"Models not isomorphic", (boolean)IsoMatcher.isomorphic(m1.getGraph(), m2.getGraph()));
        }
    }

    @Test
    public void trix_dataset() {
        DatasetGraph ds1 = RDFDataMgr.loadDatasetGraph(this.fInput);
        DatasetGraph ds2 = null;
        if (this.fExpected != null) {
            ds2 = RDFDataMgr.loadDatasetGraph(this.fExpected);
        }
        if (ds2 != null) {
            Assert.assertTrue((String)"Datasets not isomorphic", (boolean)IsoMatcher.isomorphic(ds1, ds2));
        }
    }
}

