/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.StringReader;
import java.util.List;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.RiotParsers;
import org.apache.jena.riot.system.CatchParserOutput;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestParserFactory {
    @Test
    public void ntriples_01() {
        String s = "<x> <p> <q> .";
        CatchParserOutput sink = this.parseCapture(s, Lang.NT);
        Assert.assertEquals((long)1L, (long)sink.startCalled);
        Assert.assertEquals((long)1L, (long)sink.finishCalled);
        Assert.assertEquals((long)1L, (long)sink.triples.size());
        Assert.assertEquals((long)0L, (long)sink.quads.size());
        Triple t = SSE.parseTriple("(<x> <p> <q>)");
        Assert.assertEquals((Object)t, (Object)TestParserFactory.last(sink.triples));
        Tokenizer tokenizer = TokenizerText.create().fromString("<x> <p> <q> .").build();
        sink = new CatchParserOutput();
        IRIxResolver resolver = IRIs.relativeResolver();
        ParserProfile profile = this.makeParserProfile(IRIs.relativeResolver(), null, false);
        LangNTriples parser = RiotParsers.createParserNTriples(tokenizer, sink, profile);
        parser.parse();
        Assert.assertEquals((long)1L, (long)sink.startCalled);
        Assert.assertEquals((long)1L, (long)sink.finishCalled);
        Assert.assertEquals((long)1L, (long)sink.triples.size());
        Assert.assertEquals((long)0L, (long)sink.quads.size());
        Assert.assertEquals((Object)SSE.parseTriple("(<x> <p> <q>)"), (Object)TestParserFactory.last(sink.triples));
    }

    @Test
    public void turtle_01() {
        String s = "<x> <p> <q> .";
        CatchParserOutput sink = this.parseCapture(s, Lang.TTL);
        Assert.assertEquals((long)1L, (long)sink.startCalled);
        Assert.assertEquals((long)1L, (long)sink.finishCalled);
        Assert.assertEquals((long)1L, (long)sink.triples.size());
        Assert.assertEquals((long)0L, (long)sink.quads.size());
        Triple t = SSE.parseTriple("(<http://base/x> <http://base/p> <http://base/q>)");
        Assert.assertEquals((Object)t, (Object)TestParserFactory.last(sink.triples));
    }

    private ParserProfile makeParserProfile(IRIxResolver resolver, ErrorHandler errorHandler, boolean checking) {
        if (errorHandler == null) {
            errorHandler = ErrorHandlerFactory.errorHandlerStd;
        }
        return new ParserProfileStd(RiotLib.factoryRDF(), errorHandler, resolver, PrefixMapFactory.create(), RIOT.getContext().copy(), checking, false);
    }

    @Test
    public void nquads_01() {
        String s = "<x> <p> <q> <g> .";
        CatchParserOutput sink = this.parseCapture(s, Lang.NQ);
        Assert.assertEquals((long)1L, (long)sink.startCalled);
        Assert.assertEquals((long)1L, (long)sink.finishCalled);
        Assert.assertEquals((long)0L, (long)sink.triples.size());
        Assert.assertEquals((long)1L, (long)sink.quads.size());
        Quad q = SSE.parseQuad("(<g> <x> <p> <q>)");
        Assert.assertEquals((Object)q, (Object)TestParserFactory.last(sink.quads));
    }

    @Test
    public void nquads_dft_triple() {
        String s = "<x> <p> <q> .";
        CatchParserOutput sink = this.parseCapture(s, Lang.NQ);
        Assert.assertEquals((long)1L, (long)sink.startCalled);
        Assert.assertEquals((long)1L, (long)sink.finishCalled);
        Assert.assertEquals((long)0L, (long)sink.triples.size());
        Assert.assertEquals((long)1L, (long)sink.quads.size());
        Triple t = SSE.parseTriple("(<x> <p> <q>)");
        Quad q = new Quad(Quad.defaultGraphNodeGenerated, t);
        Assert.assertEquals((Object)q, (Object)TestParserFactory.last(sink.quads));
    }

    @Test
    public void trig_dft_triple() {
        String s = "{ <x> <p> <q> }";
        CatchParserOutput sink = this.parseCapture(s, Lang.TRIG);
        Assert.assertEquals((long)1L, (long)sink.startCalled);
        Assert.assertEquals((long)1L, (long)sink.finishCalled);
        Assert.assertEquals((long)0L, (long)sink.triples.size());
        Assert.assertEquals((long)1L, (long)sink.quads.size());
        Triple t = SSE.parseTriple("(<http://base/x> <http://base/p> <http://base/q>)");
        Quad q = new Quad(Quad.defaultGraphNodeGenerated, t);
        Assert.assertEquals((Object)q, (Object)TestParserFactory.last(sink.quads));
    }

    @Test
    public void trig_02() {
        String s = "<g> { <x> <p> <q> }";
        CatchParserOutput sink = this.parseCapture(s, Lang.TRIG);
        Assert.assertEquals((long)1L, (long)sink.startCalled);
        Assert.assertEquals((long)1L, (long)sink.finishCalled);
        Assert.assertEquals((long)0L, (long)sink.triples.size());
        Assert.assertEquals((long)1L, (long)sink.quads.size());
        Quad q = SSE.parseQuad("(<http://base/g> <http://base/x> <http://base/p> <http://base/q>)");
        Assert.assertEquals((Object)q, (Object)TestParserFactory.last(sink.quads));
    }

    private CatchParserOutput parseCapture(String s, Lang lang) {
        CatchParserOutput sink = new CatchParserOutput();
        RDFParser.create().source(new StringReader(s)).base("http://base/").lang(lang).parse(sink);
        return sink;
    }

    private static <T> T last(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }
}

