/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangRDFJSON;
import org.apache.jena.riot.lang.ParserTestBaseLib;
import org.apache.jena.riot.lang.RiotParsers;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.junit.Assert;
import org.junit.Test;

public class TestLangRdfJson {
    @Test
    public void rdfjson_get_jena_reader() {
        Model m = ModelFactory.createDefaultModel();
        m.getReader("RDF/JSON");
    }

    @Test
    public void rdfjson_get_jena_writer() {
        Model m = ModelFactory.createDefaultModel();
        m.getWriter("RDF/JSON");
    }

    @Test
    public void rdfjson_read_empty_graph() {
        String s = "{}";
        String s2 = "";
        Assert.assertEquals((long)0L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    public void rdfjson_valid_trailing_comment() {
        String s = "{}//Comment";
        Assert.assertEquals((long)0L, (long)this.parseCount(s));
    }

    @Test
    public void rdfjson_read_simple_uri_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> <http://example.org/object> .";
        Assert.assertEquals((long)1L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_simple_bnode_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"bnode\" , \"value\" : \"_:id\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> _:id .";
        Assert.assertEquals((long)1L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_simple_bnode_subject() {
        String s = "{ \"_:id\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] } }";
        String s2 = "_:id <http://example.org/predicate> <http://example.org/object> .";
        Assert.assertEquals((long)1L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_simple_plainliteral_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"literal\" , \"value\" : \"some text\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> \"some text\" .";
        Assert.assertEquals((long)1L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_simple_langliteral_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"literal\" , \"value\" : \"some text\", \"lang\" : \"en-gb\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> \"some text\"@en-gb .";
        Assert.assertEquals((long)1L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_simple_typedliteral_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"literal\" , \"value\" : \"some text\", \"datatype\" : \"http://example.org/datatype\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> \"some text\"^^<http://example.org/datatype> .";
        Assert.assertEquals((long)1L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_objectlist_uris() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } , { \"type\" : \"uri\" , \"value\" : \"http://example.org/object2\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> <http://example.org/object> .\n<http://example.org/subject> <http://example.org/predicate> <http://example.org/object2> .";
        Assert.assertEquals((long)2L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_objectlist_literals() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"literal\" , \"value\" : \"some text\" } , { \"type\" : \"literal\" , \"value\" : \"more text\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> \"some text\" .\n<http://example.org/subject> <http://example.org/predicate> \"more text\" .";
        Assert.assertEquals((long)2L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_objectlist_literals2() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"literal\" , \"value\" : \"some text\" } , { \"type\" : \"literal\" , \"value\" : \"more text\", \"lang\" : \"en-gb\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> \"some text\" .\n<http://example.org/subject> <http://example.org/predicate> \"more text\"@en-gb .";
        Assert.assertEquals((long)2L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_objectlist_literals3() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"literal\" , \"value\" : \"some text\" } , { \"type\" : \"literal\" , \"value\" : \"more text\", \"datatype\" : \"http://example.org/datatype\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> \"some text\" .\n<http://example.org/subject> <http://example.org/predicate> \"more text\"^^<http://example.org/datatype> .";
        Assert.assertEquals((long)2L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_objectlist_bnodes() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"bnode\" , \"value\" : \"_:one\" } , { \"type\" : \"bnode\" , \"value\" : \"_:two\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> _:a .\n<http://example.org/subject> <http://example.org/predicate> _:b .";
        Assert.assertEquals((long)2L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_objectlist_mixed() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } , { \"type\" : \"literal\" , \"value\" : \"some text\" } , { \"type\" : \"bnode\" , \"value\" : \"_:id\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> <http://example.org/object> .\n<http://example.org/subject> <http://example.org/predicate> \"some text\" .\n<http://example.org/subject> <http://example.org/predicate> _:id .";
        Assert.assertEquals((long)3L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_predicatelist() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] , \"http://example.org/predicate2\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> <http://example.org/object> .\n<http://example.org/subject> <http://example.org/predicate2> <http://example.org/object> .";
        Assert.assertEquals((long)2L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_subjectlist() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] } , \"http://example.org/subject2\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> <http://example.org/object> .\n<http://example.org/subject2> <http://example.org/predicate> <http://example.org/object> .";
        Assert.assertEquals((long)2L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_complex() {
        String s = "{ \"http://example.org/subject\" :    {         \"http://example.org/predicate\" :        [            { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" }        ] ,        \"http://example.org/predicate2\" :        [            { \"type\" : \"literal\", \"value\" : \"some text\" }        ]    } , \"http://example.org/subject2\" :    {        \"http://example.org/predicate\" :        [            { \"type\" : \"bnode\" , \"value\" : \"_:id\" } ,            { \"type\" : \"literal\" , \"value\" : \"more text\" , \"datatype\" : \"http://example.org/datatype\" }        ]    }}";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> <http://example.org/object>.\n<http://example.org/subject> <http://example.org/predicate2> \"some text\".\n<http://example.org/subject2> <http://example.org/predicate> _:id.\n<http://example.org/subject2> <http://example.org/predicate> \"more text\"^^<http://example.org/datatype>.";
        Assert.assertEquals((long)4L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_bnode_identity() {
        String s = "{ \"_:id\" : { \"http://example.org/predicate\" : [ { \"type\" : \"bnode\" , \"value\" : \"_:id\" } ] } }";
        String s2 = "_:id <http://example.org/predicate> _:id .";
        Assert.assertEquals((long)1L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void rdfjson_read_bnode_identity2() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"bnode\" , \"value\" : \"_:id\" } ] , \"http://example.org/predicate2\" : [ { \"type\" : \"bnode\" , \"value\" : \"_:id\" } ] } }";
        String s2 = "<http://example.org/subject> <http://example.org/predicate> _:id .<http://example.org/subject> <http://example.org/predicate2> _:id .";
        Assert.assertEquals((long)2L, (long)this.parseCount(s));
        Model m = this.parseToModelRdfJson(s);
        Model m2 = this.parseToModelNTriples(s2);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_empty_string() {
        String s = "";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_unterminated_graph() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] } ";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_missing_colon_after_subject() {
        String s = "{ \"http://example.org/subject\"  { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_missing_colon_after_predicate() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\"  [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_missing_colon_in_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\"  \"uri\" , \"value\" : \"http://example.org/object\" } ] } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_unterminated_predicateobjectlist_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ]";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_unterminated_objectlist_array() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_unterminated_object_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\"";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_trailing_comma_in_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" , } ] } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_trailing_comma_after_subject() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] } , }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_trailing_comma_after_predicate() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] , } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_property_names_in_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"name\" : \"value\" } ] } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_lang_and_datatype_in_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"literal\" , \"value\" : \"some text\" , \"lang\" : \"en\" , \"datatype\" : \"http://example.org/datatype\" } ] } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_lang_and_datatype_in_object2() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"literal\" , \"value\" : \"some text\" , \"datatype\" : \"http://example.org/datatype\" , \"lang\" : \"en\" } ] } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_repeated_property_type_in_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" } ] } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_repeated_property_value_in_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"uri\" , \"value\" : \"http://example.org/object\" , \"value\" : \"http://example.org/object\" } ] } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_value_type_in_object() {
        String s = "{ \"http://example.org/subject\" : { \"http://example.org/predicate\" : [ { \"type\" : \"other\" , \"value\" : \"http://example.org/object\" } ] } }";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_array_toplevel() {
        String s = "[]";
        this.parseCount(s);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void rdfjson_invalid_trailing_content() {
        String s = "{}{}";
        this.parseCount(s);
    }

    @Test(expected=IllegalArgumentException.class)
    public void rdfjson_invalid_tokenizer() {
        byte[] b = StrUtils.asUTF8bytes("");
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        Tokenizer tokenizer = TokenizerText.create().source(in).build();
        StreamRDFCounting sink = StreamRDFLib.count();
        LangRDFJSON parser = RiotParsers.createParserRdfJson(tokenizer, sink, RiotLib.dftProfile());
    }

    private long parseCount(String string) {
        return ParserTestBaseLib.parseCount(Lang.RDFJSON, string);
    }

    private Model parseToModelNTriples(String string) {
        StringReader r = new StringReader(string);
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read(model, r, null, RDFLanguages.NTRIPLES);
        return model;
    }

    private Model parseToModelRdfJson(String string) {
        Graph g = ParserTestBaseLib.parseGraph(RDFLanguages.RDFJSON, string);
        Model model = ModelFactory.createModelForGraph(g);
        return model;
    }
}

