/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.StringReader;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.AbstractTestLangNTuples;
import org.apache.jena.riot.lang.ParserTestBaseLib;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestLangNTriples
extends AbstractTestLangNTuples {
    @Override
    protected Lang getLang() {
        return Lang.NTRIPLES;
    }

    @Test
    public void nt_reader_twice() {
        String s = "_:a <p> 'foo' . ";
        StringReader r = new StringReader(s);
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read(m, r, null, RDFLanguages.NTRIPLES);
        Assert.assertEquals((long)1L, (long)m.size());
        String x = ((Statement)m.listStatements().next()).getSubject().getId().getLabelString();
        Assert.assertNotEquals((Object)x, (Object)"a");
        r = new StringReader(s);
        RDFDataMgr.read(m, r, null, RDFLanguages.NTRIPLES);
        Assert.assertEquals((long)2L, (long)m.size());
    }

    @Test
    public void nt_model_1() {
        Model m1 = this.parseToModel("<x> <p> \"abc-\\u00E9\". ");
        Assert.assertEquals((long)1L, (long)m1.size());
        Model m2 = this.parseToModel("<x> <p> \"abc-\\u00E9\". ");
        Assert.assertTrue((boolean)m1.isIsomorphicWith(m2));
        Graph g1 = SSE.parseGraph("(graph (triple <x> <p> \"abc-\u00e9\"))");
        Assert.assertTrue((boolean)g1.isIsomorphicWith(m1.getGraph()));
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nt_only_1() {
        this.parseCount("<x> <p> <s> <g> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nt_only_2() {
        this.parseCount("BASE <http://example/>  <x> <p> <s> .");
    }

    @Test
    public void nt_only_5() {
        this.parseCount("<x> <p> \"\u00e9\" .");
    }

    @Override
    protected long parseCount(String ... strings) {
        return ParserTestBaseLib.parseCount(Lang.NTRIPLES, strings);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nt_only_5b() {
        this.parseCount(CharSpace.ASCII, "<scheme:x> <scheme:p> <scheme:\u00e9> .");
    }

    protected Model parseToModel(String string) {
        StringReader r = new StringReader(string);
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read(model, r, null, RDFLanguages.NTRIPLES);
        return model;
    }
}

