/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.lang.AbstractTestLangNTuples;
import org.apache.jena.riot.lang.ParserTestBaseLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.junit.Assert;
import org.junit.Test;

public class TestLangNQuads
extends AbstractTestLangNTuples {
    @Override
    protected Lang getLang() {
        return Lang.NQUADS;
    }

    @Test
    public void quad_1() {
        this.parseCount("<x> <p> <s> <g> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void quad_2() {
        this.parseCount("<x> <p> <s> <g>");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nq_only_1() {
        this.parseCount("<x> <p> <s> <g> <c> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nq_only_2() {
        this.parseCount("@base <http://example/> . <x> <p> <s> .");
    }

    @Test
    public void dataset_1() {
        DatasetGraph dsg = this.parseToDataset("<x> <p> <s> <g> .");
        Assert.assertEquals((long)1L, (long)dsg.size());
        Assert.assertEquals((long)1L, (long)dsg.getGraph(NodeFactory.createURI("g")).size());
        Assert.assertEquals((long)0L, (long)dsg.getDefaultGraph().size());
    }

    private DatasetGraph parseToDataset(String string) {
        return ParserTestBaseLib.parseDataset(Lang.NQUADS, string);
    }
}

