/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.ArrayList;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.SyntaxLabels;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestLabelToNode {
    private LabelToNodeFactory factory;
    private Boolean unique;
    private Boolean docScope;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        LabelToNodeFactory fSyntaxLabels = new LabelToNodeFactory(){

            @Override
            public LabelToNode create() {
                return SyntaxLabels.createLabelToNode();
            }

            public String toString() {
                return "SyntaxLabels.createLabelToNode";
            }
        };
        LabelToNodeFactory fScopeDocumentHash = new LabelToNodeFactory(){

            @Override
            public LabelToNode create() {
                return LabelToNode.createScopeByDocumentHash();
            }

            public String toString() {
                return "ScopeByDocumentHash";
            }
        };
        LabelToNodeFactory fScopeByDocumentOld = new LabelToNodeFactory(){

            @Override
            public LabelToNode create() {
                return LabelToNode.createScopeGlobal();
            }

            public String toString() {
                return "ScopeByDocumentOld";
            }
        };
        LabelToNodeFactory fScopeByGraph = new LabelToNodeFactory(){

            @Override
            public LabelToNode create() {
                return LabelToNode.createScopeByGraph();
            }

            public String toString() {
                return "ScopeByGraph";
            }
        };
        LabelToNodeFactory fUseLabelAsGiven = new LabelToNodeFactory(){

            @Override
            public LabelToNode create() {
                return LabelToNode.createUseLabelAsGiven();
            }

            public String toString() {
                return "UseLabelAsGiven";
            }
        };
        LabelToNodeFactory fUseLabelEncoded = new LabelToNodeFactory(){

            @Override
            public LabelToNode create() {
                return LabelToNode.createUseLabelEncoded();
            }

            public String toString() {
                return "UseLabelEncoded";
            }
        };
        LabelToNodeFactory fIncremental = new LabelToNodeFactory(){

            @Override
            public LabelToNode create() {
                return LabelToNode.createIncremental();
            }

            public String toString() {
                return "Incremental";
            }
        };
        x.add(new Object[]{fSyntaxLabels, true, true});
        x.add(new Object[]{fScopeDocumentHash, true, true});
        x.add(new Object[]{fScopeByDocumentOld, true, true});
        x.add(new Object[]{fScopeByGraph, false, true});
        x.add(new Object[]{fUseLabelAsGiven, true, false});
        x.add(new Object[]{fUseLabelEncoded, true, false});
        x.add(new Object[]{fIncremental, true, false});
        return x;
    }

    public TestLabelToNode(LabelToNodeFactory factory, Boolean docScope, Boolean unique) {
        this.factory = factory;
        this.docScope = docScope;
        this.unique = unique;
    }

    @Test
    public void label2node_Create1() {
        LabelToNode mapper = this.factory.create();
        Node n = (Node)mapper.create();
        Assert.assertNotNull((Object)n);
    }

    @Test
    public void label2node_Create2() {
        LabelToNode mapper = this.factory.create();
        Node n1 = (Node)mapper.create();
        Node n2 = (Node)mapper.create();
        Assert.assertNotNull((Object)n1);
        Assert.assertNotNull((Object)n2);
        Assert.assertNotEquals((Object)n1, (Object)n2);
    }

    @Test
    public void label2node_Create3() {
        LabelToNode mapper1 = this.factory.create();
        LabelToNode mapper2 = this.factory.create();
        Assert.assertNotEquals((Object)mapper1, (Object)mapper2);
        Node n1 = (Node)mapper1.create();
        Node n2 = (Node)mapper2.create();
        Assert.assertNotNull((Object)n1);
        Assert.assertNotNull((Object)n2);
        if (this.unique.booleanValue()) {
            Assert.assertNotEquals((Object)n1, (Object)n2);
        }
    }

    @Test
    public void label2node_Label1() {
        LabelToNode mapper = this.factory.create();
        Node n = (Node)mapper.get(null, "label");
        Assert.assertNotNull((Object)n);
    }

    @Test
    public void label2node_Label2() {
        LabelToNode mapper = this.factory.create();
        Node n1 = (Node)mapper.get(null, "label1");
        Node n2 = (Node)mapper.get(null, "label2");
        Assert.assertNotNull((Object)n1);
        Assert.assertNotNull((Object)n2);
        Assert.assertNotEquals((Object)n1, (Object)n2);
    }

    @Test
    public void label2node_Label3() {
        LabelToNode mapper = this.factory.create();
        Node n1 = (Node)mapper.get(null, "label1");
        Node n2 = (Node)mapper.get(null, "label1");
        Assert.assertNotNull((Object)n1);
        Assert.assertNotNull((Object)n2);
        Assert.assertEquals((Object)n1, (Object)n2);
    }

    @Test
    public void label2node_Label4() {
        Node g = NodeFactory.createURI("g");
        LabelToNode mapper = this.factory.create();
        Node n1 = (Node)mapper.get(g, "label1");
        Node n2 = (Node)mapper.get(g, "label1");
        Assert.assertNotNull((Object)n1);
        Assert.assertNotNull((Object)n2);
        Assert.assertEquals((Object)n1, (Object)n2);
    }

    @Test
    public void label2node_Label5() {
        Node g1 = NodeFactory.createURI("g1");
        Node g2 = NodeFactory.createURI("g2");
        LabelToNode mapper = this.factory.create();
        Node n1 = (Node)mapper.get(g1, "label1");
        Node n2 = (Node)mapper.get(g2, "label1");
        Assert.assertNotNull((Object)n1);
        Assert.assertNotNull((Object)n2);
        if (this.docScope.booleanValue()) {
            Assert.assertEquals((Object)n1, (Object)n2);
        } else {
            Assert.assertNotEquals((Object)n1, (Object)n2);
        }
    }

    @Test
    public void label2node_Label6() {
        Node g = NodeFactory.createURI("g");
        LabelToNode mapper = this.factory.create();
        Node n1 = (Node)mapper.get(g, "label1");
        Node n2 = (Node)mapper.get(null, "label1");
        if (this.docScope.booleanValue()) {
            Assert.assertEquals((Object)n1, (Object)n2);
        } else {
            Assert.assertNotEquals((Object)n1, (Object)n2);
        }
    }

    @Test
    public void label2node_Label7() {
        Node g1 = NodeFactory.createURI("g1");
        Node g2 = NodeFactory.createURI("g1");
        LabelToNode mapper = this.factory.create();
        Node n1 = (Node)mapper.get(g1, "label1");
        Node n2 = (Node)mapper.get(g2, "label2");
        Assert.assertNotNull((Object)n1);
        Assert.assertNotNull((Object)n2);
        Assert.assertNotEquals((Object)n1, (Object)n2);
    }

    @Test
    public void label2node_Reset1() {
        LabelToNode mapper = this.factory.create();
        Node n1 = (Node)mapper.get(null, "label1");
        mapper.clear();
        Node n2 = (Node)mapper.get(null, "label1");
        Assert.assertNotNull((Object)n1);
        Assert.assertNotNull((Object)n2);
        if (this.unique.booleanValue()) {
            if (n1.equals(n2)) {
                System.err.println("equals");
            }
            Assert.assertNotEquals((Object)n1, (Object)n2);
        } else {
            Assert.assertEquals((Object)n1, (Object)n2);
        }
    }

    @Test
    public void label2node_Reset2() {
        LabelToNode mapper = this.factory.create();
        Node g = NodeFactory.createURI("g");
        Node n1 = (Node)mapper.get(g, "label1");
        mapper.clear();
        Node n2 = (Node)mapper.get(g, "label1");
        Assert.assertNotNull((Object)n1);
        Assert.assertNotNull((Object)n2);
        if (this.unique.booleanValue()) {
            Assert.assertNotEquals((Object)n1, (Object)n2);
        } else {
            Assert.assertEquals((Object)n1, (Object)n2);
        }
    }

    public static interface LabelToNodeFactory {
        public LabelToNode create();
    }
}

