/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.ByteArrayInputStream;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.irix.IRIs;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.ParserTestBaseLib;
import org.apache.jena.riot.lang.RiotParsers;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractTestLangNTuples {
    private static ErrorHandler errorhandler = null;

    @BeforeClass
    public static void beforeClass() {
        errorhandler = ErrorHandlerFactory.getDefaultErrorHandler();
        ErrorHandlerFactory.setDefaultErrorHandler(ErrorHandlerFactory.errorHandlerNoLogging);
    }

    @AfterClass
    public static void afterClass() {
        ErrorHandlerFactory.setDefaultErrorHandler(errorhandler);
    }

    @Test
    public void tuple_0() {
        long count = this.parseCount("");
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void tuple_1() {
        long count = this.parseCount("<x> <y> <z>.");
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void tuple_2() {
        long count = this.parseCount("<x> <y> \"z\".");
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void tuple_3() {
        long count = this.parseCount("<x> <y> <z>. <x> <y> <z>.");
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void tuple_4() {
        long count = this.parseCount("<x> <y> \"123\"^^<int>.");
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void tuple_5() {
        long count = this.parseCount("<x> <y> \"123\"@lang.");
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_01() {
        this.parseCount("<x> <y> <z>");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_02() {
        this.parseCount("<x> _:a <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_03() {
        this.parseCount("<x> \"p\" <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_4() {
        this.parseCount("\"x\" <p> <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_5() {
        this.parseCount("<x> <p> ?var .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_6() {
        this.parseCount("<x> <p> 123 .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_7() {
        this.parseCount("<x> <p> x:y .");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void tuple_bad_10() {
        this.parseCount("<x> <p> <bad uri> .");
    }

    @Test
    public void tuple_bad_11() {
        this.parseCount("<x> <p> \"9000\"^^<http://www.w3.org/2001/XMLSchema#byte> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void tuple_bad_21() {
        this.parseCheck("<x> <p> <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_22() {
        this.parseCheck("<http://example/x> <http://example/p> \"abc\"^^<http://example/bad uri> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void tuple_bad_23() {
        this.parseCheck("<http://example/x> <http://example/p> \"9000\"^^<http://www.w3.org/2001/XMLSchema#byte> .");
    }

    @Test
    public void tuple_charset_1() {
        this.parseCheck("<http://example/x\\u00E9> <http://example/p> <http://example/s> .");
    }

    @Test
    public void tuple_charset_2() {
        this.parseCheck("<http://example/\u00e9> <http://example/p> \"\u00e9\" .");
    }

    protected static Tokenizer tokenizer(CharSpace charSpace, String string) {
        byte[] b = StrUtils.asUTF8bytes(string);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        Tokenizer tokenizer = charSpace == CharSpace.ASCII ? TokenizerText.create().asciiOnly(true).source(in).build() : TokenizerText.create().source(in).build();
        return tokenizer;
    }

    protected static Tokenizer tokenizer(String string) {
        byte[] b = StrUtils.asUTF8bytes(string);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        Tokenizer tokenizer = TokenizerText.create().source(in).build();
        return tokenizer;
    }

    protected final void parseCheck(String ... strings) {
        String string = String.join((CharSequence)"\n", strings);
        Tokenizer tokenizer = AbstractTestLangNTuples.tokenizer(string);
        StreamRDFCounting sink = StreamRDFLib.count();
        LangNQuads x = RiotParsers.createParserNQuads(tokenizer, sink, AbstractTestLangNTuples.parserProfile(new ErrorHandlerTestLib.ErrorHandlerEx()));
        x.parse();
    }

    protected final long parseCount(CharSpace charSpace, String ... strings) {
        String string = String.join((CharSequence)"\n", strings);
        Tokenizer tokenizer = AbstractTestLangNTuples.tokenizer(charSpace, string);
        StreamRDFCounting sink = StreamRDFLib.count();
        LangNTriples x = RiotParsers.createParserNTriples(tokenizer, sink, AbstractTestLangNTuples.parserProfile(new ErrorHandlerTestLib.ErrorHandlerEx()));
        x.parse();
        return sink.count();
    }

    static ParserProfile parserProfile(ErrorHandler errorHandler) {
        return new ParserProfileStd(RiotLib.factoryRDF(), errorHandler, IRIs.absoluteResolver(), PrefixMapFactory.emptyPrefixMap(), RIOT.getContext().copy(), true, false);
    }

    protected abstract Lang getLang();

    protected long parseCount(String ... strings) {
        return ParserTestBaseLib.parseCount(this.getLang(), strings);
    }
}

