/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.InputStream;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.adapters.AdapterFileManager;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.LocationMapper;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileManager {
    static Logger log = LoggerFactory.getLogger(TestFileManager.class);
    public static final String testingDir = "testing/RIOT/FileManager";
    static final String filename = "fmgr-test-file";
    static final String filenameNonExistent = "fmgr-test-file-1421";
    static final String fileModel = "foo.ttl";
    static final String zipname = "testing/RIOT/FileManager/fmgr-test.zip";

    @Test
    public void testFileManagerFileLocator() {
        FileManager fileManager = FileManager.create();
        fileManager.addLocatorFile();
        InputStream in = fileManager.open("testing/RIOT/FileManager/fmgr-test-file");
        Assert.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    @Test
    public void testFileManagerFileLocatorWithDir() {
        FileManager fileManager = FileManager.create();
        fileManager.addLocatorFile(testingDir);
        InputStream in = fileManager.open(filename);
        Assert.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    @Test
    public void testFileManagerNoFile() {
        FileManager fileManager = FileManager.create();
        fileManager.addLocatorFile();
        try {
            InputStream in = fileManager.open(filenameNonExistent);
            this.closeInputStream(in);
            Assert.assertNull((String)"Found non-existant file: fmgr-test-file-1421", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test(expected=NotFoundException.class)
    public void testFileManagerNoFile2() {
        FileManager fileManager = FileManager.create();
        fileManager.addLocatorFile();
        fileManager.readModelInternal(ModelFactory.createDefaultModel(), filenameNonExistent);
    }

    @Test(expected=NotFoundException.class)
    public void testFileManagerNoFile3() {
        AdapterFileManager fileManager = new AdapterFileManager(new StreamManager(), new org.apache.jena.riot.system.stream.LocationMapper());
        fileManager.addLocatorFile();
        fileManager.readModelInternal(ModelFactory.createDefaultModel(), filenameNonExistent);
    }

    @Test
    public void testFileManagerLocatorClassLoader() {
        FileManager fileManager = FileManager.create();
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        InputStream in = fileManager.open("java/lang/String.class");
        Assert.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    @Test
    public void testFileManagerLocatorClassLoaderNotFound() {
        FileManager fileManager = FileManager.create();
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        try {
            InputStream in = fileManager.open("not/java/lang/String.class");
            this.closeInputStream(in);
            Assert.assertNull((String)"Found non-existant class", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testFileManagerLocatorZip() {
        FileManager fileManager = FileManager.create();
        try {
            fileManager.addLocatorZip(zipname);
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to create a filemanager and add a zip locator");
        }
        InputStream in = fileManager.open(filename);
        Assert.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    @Test
    public void testFileManagerLocatorZipNonFound() {
        FileManager fileManager = FileManager.create();
        try {
            fileManager.addLocatorZip(zipname);
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to create a filemanager and add a zip locator");
        }
        try {
            InputStream in = fileManager.open(filenameNonExistent);
            this.closeInputStream(in);
            Assert.assertNull((String)"Found non-existant zip file member", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testFileManagerClone() {
        FileManager fileManager1 = FileManager.create();
        FileManager fileManager2 = fileManager1.clone();
        fileManager1.addLocatorFile();
        InputStream in = fileManager1.open("testing/RIOT/FileManager/fmgr-test-file");
        Assert.assertNotNull((Object)in);
        this.closeInputStream(in);
        try {
            in = fileManager2.open("testing/RIOT/FileManager/fmgr-test-file");
            this.closeInputStream(in);
            Assert.assertNull((String)"Found file via wrong FileManager", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testFileManagerReadOntModel() {
        OntModel model = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        FileManager.getInternal().readModelInternal(model, "testing/RIOT/FileManager/data.ttl");
        Individual ind = model.getIndividual("http://example.com/individual");
        String t = ind.getOntClass().getURI();
        Assert.assertEquals((Object)"http://example.com/T", (Object)t);
        long c1 = model.size();
        model.loadImports();
        long c2 = model.size();
        Assert.assertEquals((long)c1, (long)c2);
    }

    @Test
    public void testLocationMappingURLtoFileOpen() {
        LocationMapper locMap = new LocationMapper("location-mapping-test.ttl;testing/RIOT/FileManager/location-mapping-test.ttl");
        FileManager fileManager = FileManager.create(locMap);
        fileManager.addLocatorFile();
        InputStream in = fileManager.open("http://example.org/file");
        Assert.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    @Test
    public void testLocationMappingURLtoFileOpenNotFound() {
        LocationMapper locMap = new LocationMapper("location-mapping-test.ttl;testing/RIOT/FileManager/location-mapping-test.ttl");
        FileManager fileManager = FileManager.create(locMap);
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        try {
            InputStream in = fileManager.open("http://example.org/file");
            this.closeInputStream(in);
            Assert.assertNull((String)"Found nont-existant URL", null);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCache1() {
        FileManager fileManager = FileManager.create();
        fileManager.addLocatorFile(testingDir);
        Model m1 = fileManager.loadModelInternal(fileModel);
        Model m2 = fileManager.loadModelInternal(fileModel);
        Assert.assertNotSame((Object)m1, (Object)m2);
    }

    @Test
    public void testCache2() {
        FileManager.setGlobalFileManager(AdapterFileManager.get());
        FileManager fileManager = FileManager.getInternal();
        fileManager.addLocatorFile(testingDir);
        fileManager.setModelCaching(true);
        Model m1 = fileManager.loadModelInternal(fileModel);
        Model m2 = fileManager.loadModelInternal(fileModel);
        Assert.assertSame((Object)m1, (Object)m2);
    }

    @Test
    public void testCache3() {
        FileManager fileManager = FileManager.getInternal();
        fileManager.addLocatorFile(testingDir);
        fileManager.setModelCaching(true);
        Model m1 = fileManager.loadModelInternal(fileModel);
        Model m2 = fileManager.loadModelInternal(fileModel);
        Assert.assertSame((Object)m1, (Object)m2);
        fileManager.removeCacheModel(fileModel);
        Model m3 = fileManager.loadModelInternal(fileModel);
        Assert.assertNotSame((Object)m1, (Object)m3);
        fileManager.resetCache();
        Model m4 = fileManager.loadModelInternal(fileModel);
        Model m5 = fileManager.loadModelInternal(fileModel);
        Assert.assertSame((Object)m4, (Object)m5);
        Assert.assertNotSame((Object)m1, (Object)m4);
        Assert.assertNotSame((Object)m3, (Object)m4);
    }

    private void closeInputStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

