/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.ArrayList;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RIOT;
import org.apache.jena.sparql.graph.GraphFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTurtleWriterPretty {
    private static String DIR = "testing/RIOT/Writer/";
    private static String BASE = "http://BASE/";
    private final RDFFormat format;
    private final String filename;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        x.add(new Object[]{"Turtle/Pretty", RDFFormat.TURTLE_PRETTY});
        x.add(new Object[]{"Trig/Pretty", RDFFormat.TRIG_PRETTY});
        return x;
    }

    public TestTurtleWriterPretty(String name, RDFFormat format) {
        this.format = format;
        this.filename = format.getLang().equals(Lang.TRIG) ? DIR + "rdfwriter-02.trig" : DIR + "rdfwriter-01.ttl";
    }

    private static Graph data(String fn, String baseURI) {
        Graph g1 = GraphFactory.createDefaultGraph();
        RDFParser.create().base(BASE).source(fn).parse(g1);
        return g1;
    }

    @Test
    public void writer_parse_base_2() {
        Assume.assumeTrue((boolean)this.format.getVariant().equals(RDFFormat.PRETTY));
        Graph g = TestTurtleWriterPretty.data(this.filename, BASE);
        String written = RDFWriter.create().base(BASE).source(g).set(RIOT.symTurtleDirectiveStyle, "sparql").set(RIOT.symTurtleOmitBase, true).format(this.format).base(BASE).asString();
        Graph g1 = GraphFactory.createDefaultGraph();
        RDFParser.create().base(BASE).fromString(written).lang(Lang.TTL).parse(g1);
        Assert.assertTrue((boolean)g.isIsomorphicWith(g1));
        Graph g2 = GraphFactory.createDefaultGraph();
        String BASE2 = "http://BASE2/";
        RDFParser.create().base(BASE2).fromString(written).lang(Lang.TTL).parse(g2);
        Assert.assertFalse((boolean)g.isIsomorphicWith(g2));
    }
}

