/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.ArrayList;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RIOT;
import org.apache.jena.sparql.graph.GraphFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTurtleWriter {
    private static String DIR = "testing/RIOT/Writer/";
    private static String BASE = "http://BASE/";
    private final RDFFormat format;
    private final String filename;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        x.add(new Object[]{"Turtle", RDFFormat.TURTLE});
        x.add(new Object[]{"Turtle/Pretty", RDFFormat.TURTLE_PRETTY});
        x.add(new Object[]{"Turtle/Blocks", RDFFormat.TURTLE_BLOCKS});
        x.add(new Object[]{"Turtle/Flat", RDFFormat.TURTLE_FLAT});
        x.add(new Object[]{"Trig", RDFFormat.TRIG});
        x.add(new Object[]{"Trig/Pretty", RDFFormat.TRIG_PRETTY});
        x.add(new Object[]{"Trig/Blocks", RDFFormat.TRIG_BLOCKS});
        x.add(new Object[]{"Trig/Flat", RDFFormat.TRIG_FLAT});
        return x;
    }

    public TestTurtleWriter(String name, RDFFormat format) {
        this.format = format;
        this.filename = format.getLang().equals(Lang.TRIG) ? DIR + "rdfwriter-02.trig" : DIR + "rdfwriter-01.ttl";
    }

    private static Graph data(String fn, String baseURI) {
        Graph g1 = GraphFactory.createDefaultGraph();
        RDFParser.create().base(BASE).source(fn).parse(g1);
        return g1;
    }

    @Test
    public void writer_parse_base_1() {
        Graph g = TestTurtleWriter.data(this.filename, BASE);
        String written = RDFWriter.create().base(BASE).source(g).set(RIOT.symTurtleDirectiveStyle, "sparql").format(this.format).base(BASE).asString();
        Assert.assertTrue((boolean)written.contains("<>"));
        Assert.assertTrue((boolean)written.contains("BASE"));
    }
}

