/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.Locale;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.base.Sys;
import org.apache.jena.riot.SysRIOT;
import org.junit.Assert;
import org.junit.Test;
import org.python.google.common.base.Predicate;

public class TestSysRIOT {
    @Test
    public void chooseBaseIRI_1() {
        this.testChooseBaseIRI("http://example/foo/bar", "http://example/foo/bar");
    }

    @Test
    public void chooseBaseIRI_2() {
        this.testChooseBaseIRI("-", "http://localhost/stdin/");
    }

    @Test
    public void chooseBaseIRI_3() {
        if (Sys.isWindows) {
            if (IO.exists("c:/")) {
                this.testChooseBaseIRI("c:", (Predicate<String>)((Predicate)s -> s.toLowerCase(Locale.ROOT).startsWith("file:///c:/")));
            }
        } else {
            this.testChooseBaseIRI("x:", "x:");
        }
    }

    @Test
    public void chooseBaseIRI_4() {
        if (Sys.isWindows) {
            if (IO.exists("c:/")) {
                this.testChooseBaseIRI("c:", (Predicate<String>)((Predicate)s -> s.toLowerCase(Locale.ROOT).startsWith("file:///c:/")));
            }
        } else {
            this.testChooseBaseIRI("x:/", "x:/");
        }
    }

    @Test
    public void chooseBaseIRI_10() {
        this.testChooseBaseIRI("foo", (Predicate<String>)((Predicate)s -> s.startsWith("file:///")));
    }

    private void testChooseBaseIRI(String input, String expected) {
        String x = SysRIOT.chooseBaseIRI(null, input);
        Assert.assertEquals((Object)expected, (Object)x);
    }

    private void testChooseBaseIRI(String input, Predicate<String> test) {
        String x = SysRIOT.chooseBaseIRI(null, input);
        Assert.assertTrue((boolean)test.apply((Object)x));
    }
}

