/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.junit.Assert;
import org.junit.Test;

public class TestRiotReader {
    @Test
    public void testCreateIteratorTriples_01() {
        Iterator<Triple> it = RDFDataMgr.createIteratorTriples(new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)), RDFLanguages.NTRIPLES, "http://example/");
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testEncodedUTF8() {
        Iterator<Triple> it = RDFDataMgr.createIteratorTriples(new ByteArrayInputStream("<a> <b> \"\\u263A\" .".getBytes(StandardCharsets.UTF_8)), RDFLanguages.NTRIPLES, null);
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"\u263a", (Object)it.next().getObject().getLiteralLexicalForm());
    }

    @Test
    public void testRawUTF8() {
        Iterator<Triple> it = RDFDataMgr.createIteratorTriples(new ByteArrayInputStream("<a> <b> \"\u263a\" .".getBytes(StandardCharsets.UTF_8)), RDFLanguages.NTRIPLES, null);
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"\u263a", (Object)it.next().getObject().getLiteralLexicalForm());
    }

    @Test
    public void testCreateIteratorTriples_02() {
        String x = StrUtils.strjoinNL("<rdf:RDF", "   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"", "   xmlns:j.0=\"http://example/\">", "  <rdf:Description rdf:about=\"http://example/s\">", "     <j.0:p rdf:resource=\"http://example/o\"/>", "   </rdf:Description>", "</rdf:RDF>");
        Iterator<Triple> it = RDFDataMgr.createIteratorTriples(new ByteArrayInputStream(x.getBytes()), RDFLanguages.RDFXML, "http://example/");
        Assert.assertTrue((boolean)it.hasNext());
        Triple t = it.next();
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)"http://example/s", (Object)t.getSubject().getURI());
        Assert.assertEquals((Object)"http://example/p", (Object)t.getPredicate().getURI());
        Assert.assertEquals((Object)"http://example/o", (Object)t.getObject().getURI());
        Assert.assertFalse((boolean)it.hasNext());
    }
}

