/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.JsonLDReadContext;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonLDReader {
    private static Resource person1 = ResourceFactory.createResource("http://schema.org/Person");
    private static Resource person2 = ResourceFactory.createResource("https://schema.org/Person");
    private static Property name1 = ResourceFactory.createProperty("http://schema.org/name");
    private static Property name2 = ResourceFactory.createProperty("https://schema.org/name");

    @Test
    public final void simpleReadTest() throws IOException {
        String jsonld = this.someSchemaDorOrgJsonld();
        Dataset ds = this.jsonld2dataset(jsonld, null);
        this.assertJohnDoeIsOK(ds.getDefaultModel());
    }

    @Test
    public final void overrideAtContextTest() throws JsonGenerationException, IOException {
        String jsonld = this.someSchemaDorOrgJsonld();
        JsonLDReadContext jenaCtx = new JsonLDReadContext();
        jenaCtx.setJsonLDContext(this.schemaOrgResolvedContext());
        Dataset ds = this.jsonld2dataset(jsonld, jenaCtx);
        this.assertJohnDoeIsOK(ds.getDefaultModel());
    }

    @Test
    public final void overrideJsonLdOptions() throws JsonGenerationException, IOException {
        String jsonld = "{\"@id\":\"_:b0\",\"@type\":\"Person\",\"name\":\"John Doe\",\"@context\":\"http://pseudo.schema.org\"}";
        JsonLdOptions options = new JsonLdOptions();
        DocumentLoader dl = new DocumentLoader();
        dl.addInjectedDoc("http://pseudo.schema.org", String.format("{ \"@context\": %s }", this.schemaOrgResolvedContext()));
        options.setDocumentLoader(dl);
        JsonLDReadContext jenaCtx = new JsonLDReadContext();
        jenaCtx.setOptions(options);
        Dataset ds = this.jsonld2dataset(jsonld, jenaCtx);
        this.assertJohnDoeIsOK(ds.getDefaultModel());
    }

    private Dataset jsonld2dataset(String jsonld, Context jenaCtx) throws IOException {
        Dataset ds = DatasetFactory.create();
        try (ByteArrayInputStream in = new ByteArrayInputStream(jsonld.getBytes(StandardCharsets.UTF_8));){
            RDFParser.create().source(in).errorHandler(ErrorHandlerFactory.errorHandlerNoLogging).lang(Lang.JSONLD).context(jenaCtx).parse(ds.asDatasetGraph());
        }
        return ds;
    }

    private String someSchemaDorOrgJsonld() {
        return String.format("{\"@id\": \"_:b0\", \"@type\": \"Person\", \"name\": \"John Doe\", %s }", this.schemaOrgContext());
    }

    private String schemaOrgContext() {
        return "\"@context\": \"http://schema.org/\"";
    }

    private String schemaOrgResolvedContext() {
        return "{\"name\":{\"@id\":\"http://schema.org/name\"},\"Person\": {\"@id\": \"http://schema.org/Person\"}}";
    }

    private void assertJohnDoeIsOK(Model m) {
        Assert.assertTrue((m.contains(null, RDF.type, person1) || m.contains(null, RDF.type, person2) ? 1 : 0) != 0);
        Assert.assertTrue((m.contains(null, name1, "John Doe") || m.contains(null, name2, "John Doe") ? 1 : 0) != 0);
    }
}

