/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Paths;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.adapters.RDFReaderFactoryRIOT;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestJenaReaderRIOT {
    private static final String directory = "testing/RIOT/Reader";
    private static Context context = new Context();
    private static final String plainRelFnTTL = "testing/RIOT/Reader/D.ttl";
    private static final String plainRelFnRDFXML = "testing/RIOT/Reader/D.rdf";

    @Test
    public void read_01() {
        TestJenaReaderRIOT.jenaread("D.nt");
    }

    @Test
    public void read_02() {
        TestJenaReaderRIOT.jenaread("D.ttl");
    }

    @Test
    public void read_03() {
        TestJenaReaderRIOT.jenaread("D.rdf");
    }

    @Test
    public void read_04() {
        TestJenaReaderRIOT.jenaread("D.rdf");
    }

    @Test
    public void read_05() {
        TestJenaReaderRIOT.jenaread("D.rj");
    }

    @Test
    public void read_06() {
        TestJenaReaderRIOT.jenaread("D.jsonld");
    }

    @Test
    public void read_11() {
        TestJenaReaderRIOT.jenaread("D.nt", "N-TRIPLES");
    }

    @Test
    public void read_12() {
        TestJenaReaderRIOT.jenaread("D.ttl", "TTL");
    }

    @Test
    public void read_13() {
        TestJenaReaderRIOT.jenaread("D.rdf", "RDF/XML");
    }

    @Test
    public void read_14() {
        TestJenaReaderRIOT.jenaread("D.rdf", "RDF/XML-ABBREV");
    }

    @Test
    public void read_15() {
        TestJenaReaderRIOT.jenaread("D.rj", "RDF/JSON");
    }

    @Test
    public void read_16() {
        TestJenaReaderRIOT.jenaread("D.jsonld", "JSON-LD");
    }

    @Test
    public void read_21a() {
        TestJenaReaderRIOT.jenaread("D-nt", "N-TRIPLES");
    }

    @Test
    public void read_21b() {
        TestJenaReaderRIOT.jenaread("D-nt", "NTRIPLES");
    }

    @Test
    public void read_21c() {
        TestJenaReaderRIOT.jenaread("D-nt", "NT");
    }

    @Test
    public void read_21d() {
        TestJenaReaderRIOT.jenaread("D-nt", "N-Triples");
    }

    @Test
    public void read_22a() {
        TestJenaReaderRIOT.jenaread("D-ttl", "TURTLE");
    }

    @Test
    public void read_22b() {
        TestJenaReaderRIOT.jenaread("D-ttl", "TTL");
    }

    @Test
    public void read_23a() {
        TestJenaReaderRIOT.jenaread("D-rdf", "RDF/XML");
    }

    @Test
    public void read_23b() {
        TestJenaReaderRIOT.jenaread("D-rdf", "RDFXML");
    }

    @Test
    public void read_24() {
        TestJenaReaderRIOT.jenaread("D-json", "RDF/JSON");
    }

    @Test
    public void read_30() {
        TypedInputStream in = RDFDataMgr.open(TestJenaReaderRIOT.filename("D-not-TTL.ttl"));
        Model m0 = ModelFactory.createDefaultModel();
        RDFDataMgr.read(m0, (InputStream)in, RDFLanguages.RDFXML);
        TypedInputStream in1 = RDFDataMgr.open(TestJenaReaderRIOT.filename("D-not-TTL.ttl"));
        Model m1 = ModelFactory.createDefaultModel();
        m1.read(in1, null, "RDF/XML");
    }

    @Test
    public void read_StringReader_31() {
        String x = "<s> <p> <p> .";
        StringReader s = new StringReader(x);
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read(m, s, null, RDFLanguages.NTRIPLES);
        StringReader s1 = new StringReader("<s> <p> <p> .");
        Model m1 = ModelFactory.createDefaultModel();
        m1.read(s1, null, "N-TRIPLES");
    }

    @Test
    public void read_StringReader_32() {
        String x = StrUtils.strjoinNL("<rdf:RDF", "   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"", "   xmlns:j.0=\"http://example/\">", "  <rdf:Description rdf:about=\"http://example/s\">", "     <j.0:p rdf:resource=\"http://example/o\"/>", "   </rdf:Description>", "</rdf:RDF>");
        StringReader s = new StringReader(x);
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read(m, s, null, RDFLanguages.RDFXML);
        StringReader s1 = new StringReader(x);
        m = ModelFactory.createDefaultModel();
        m.read(s1, null, "RDF/XML");
    }

    @Test
    public void read_base_1() {
        TestJenaReaderRIOT.jenaread("D-no-base.ttl", "TTL", "http://baseuri/");
    }

    @Test
    public void read_input_1() throws IOException {
        TestJenaReaderRIOT.jenaread_stream("D.ttl", "TTL");
    }

    @Test
    public void read_input_2() throws IOException {
        TestJenaReaderRIOT.jenaread_stream("D.rdf", "RDF/XML");
    }

    @Test
    public void read_url_1() {
        TestJenaReaderRIOT.modelRead(plainRelFnTTL);
    }

    @Test
    public void read_url_1x() {
        TestJenaReaderRIOT.modelRead(plainRelFnRDFXML);
    }

    @Test
    public void read_url_2() {
        TestJenaReaderRIOT.modelRead("file:testing/RIOT/Reader/D.ttl");
    }

    @Test
    public void read_url_2x() {
        TestJenaReaderRIOT.modelRead("file:testing/RIOT/Reader/D.rdf");
    }

    @Test
    public void read_url_3() {
        String cwd = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        TestJenaReaderRIOT.modelRead("file:" + cwd + "/testing/RIOT/Reader/D.ttl");
    }

    @Test
    public void read_url_3x() {
        String cwd = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        TestJenaReaderRIOT.modelRead("file:" + cwd + "/testing/RIOT/Reader/D.rdf");
    }

    @Test
    public void read_url_4() {
        String cwd = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        String fn = "file:" + cwd + "/testing/RIOT/Reader/D.ttl";
        String fn2 = IRILib.filenameToIRI(fn);
        TestJenaReaderRIOT.modelRead(fn2);
    }

    @Test
    public void read_url_4x() {
        String cwd = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        String fn = "file:" + cwd + "/testing/RIOT/Reader/D.rdf";
        String fn2 = IRILib.filenameToIRI(fn);
        TestJenaReaderRIOT.modelRead(fn2);
    }

    private static Model modelRead(String fn) {
        Model m = ModelFactory.createDefaultModel();
        m.read(fn);
        return m;
    }

    private static String filename(String filename) {
        return "testing/RIOT/Reader/" + filename;
    }

    private static void jenaread_stream(String filename, String lang) throws IOException {
        filename = TestJenaReaderRIOT.filename(filename);
        try (FileInputStream in0 = new FileInputStream(filename);){
            Model m0 = ModelFactory.createDefaultModel();
            RDFDataMgr.read(m0, (InputStream)in0, "http://example/base2", RDFLanguages.nameToLang(lang));
        }
        try (FileInputStream in1 = new FileInputStream(filename);){
            Model m1 = ModelFactory.createDefaultModel();
            RDFDataMgr.read(m1, (InputStream)in1, RDFLanguages.nameToLang(lang));
        }
        Model m2 = ModelFactory.createDefaultModel();
        try (FileInputStream in2 = new FileInputStream(filename);){
            m2.read(in2, "http://example/base3", lang);
        }
        String x = FileUtils.readWholeFileAsUTF8(filename);
        Model m3 = ModelFactory.createDefaultModel();
        m2.read(new StringReader(x), "http://example/base4", lang);
    }

    private static void jenaread(String dataurl) {
        dataurl = TestJenaReaderRIOT.filename(dataurl);
        Model m = ModelFactory.createDefaultModel();
        m.read(dataurl);
        Assert.assertTrue((m.size() != 0L ? 1 : 0) != 0);
    }

    private static void jenaread(String dataurl, String lang) {
        dataurl = TestJenaReaderRIOT.filename(dataurl);
        Model m0 = ModelFactory.createDefaultModel();
        RDFDataMgr.read(m0, dataurl, RDFLanguages.nameToLang(lang));
        Assert.assertTrue((m0.size() != 0L ? 1 : 0) != 0);
        Model m1 = ModelFactory.createDefaultModel();
        new RDFReaderFactoryRIOT().getReader(lang).read(m1, dataurl);
        Assert.assertTrue((m1.size() != 0L ? 1 : 0) != 0);
        Model m2 = ModelFactory.createDefaultModel();
        String x = RDFLanguages.nameToLang(lang).getName();
        m2.read(dataurl, x);
        Assert.assertTrue((m2.size() != 0L ? 1 : 0) != 0);
    }

    private static void jenaread(String dataurl, String lang, String base) {
        dataurl = TestJenaReaderRIOT.filename(dataurl);
        Model m1 = ModelFactory.createDefaultModel();
        Model m2 = ModelFactory.createDefaultModel();
        RDFDataMgr.read(m1, dataurl, base, RDFLanguages.nameToLang(lang));
        m2.read("file:" + dataurl, base, lang);
        Assert.assertTrue((m1.size() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((m2.size() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)m1.isIsomorphicWith(m2));
        Resource s = ((Statement)m1.listStatements().next()).getSubject();
        Assert.assertTrue((boolean)s.getURI().startsWith("http://"));
        Assert.assertTrue((boolean)s.getURI().equals("http://baseuri/s"));
    }
}

