/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.rdfs.setup.ConfigRDFS;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.lang.CollectorStreamTriples;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamRDFS {
    static final String DIR = "testing/RDFS";
    static final String DATA_FILE = "testing/RDFS/rdfs-data.ttl";
    static final String VOCAB_FILE = "testing/RDFS/rdfs-vocab.ttl";
    protected static Graph vocab = RDFDataMgr.loadGraph("testing/RDFS/rdfs-vocab.ttl");
    protected static Graph data = RDFDataMgr.loadGraph("testing/RDFS/rdfs-data.ttl");
    protected static ConfigRDFS<Node> setup;
    private static Node node_c;
    private static Node node_X;
    private static Node node_p;
    private static Node node_Q;
    private static Node node_Q2;
    private static Node rdfType;

    @Test
    public void basic_0() {
        List<Triple> results = TestStreamRDFS.infOutput(stream -> StreamRDFOps.sendGraphToStream(data, stream));
        HashSet<Triple> resultSet = new HashSet<Triple>(results);
        Assert.assertEquals((long)5L, (long)data.size());
        Assert.assertEquals((long)13L, (long)resultSet.size());
        Assert.assertEquals((long)13L, (long)results.size());
    }

    @Test
    public void infer_1() {
        Triple t = SSE.parseTriple("(:c :p :x)");
        List<Triple> results = TestStreamRDFS.infOutput(x -> x.triple(t));
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertTrue((boolean)TestStreamRDFS.listContains(results, "(:c :p :x)"));
        Assert.assertTrue((boolean)TestStreamRDFS.listContains(results, "(:c :pTop :x)"));
        Assert.assertTrue((boolean)TestStreamRDFS.listContains(results, "(:c rdf:type :Q)"));
        Assert.assertTrue((boolean)TestStreamRDFS.listContains(results, "(:c rdf:type :Q2)"));
    }

    @Test
    public void infer_2() {
        Triple t = SSE.parseTriple("(:X rdf:type :T)");
        List<Triple> results = TestStreamRDFS.infOutput(x -> x.triple(t));
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertTrue((boolean)TestStreamRDFS.listContains(results, "(:X rdf:type :T)"));
        Assert.assertTrue((boolean)TestStreamRDFS.listContains(results, "(:X rdf:type :T2)"));
        Assert.assertTrue((boolean)TestStreamRDFS.listContains(results, "(:X rdf:type :T3)"));
        Assert.assertTrue((boolean)TestStreamRDFS.listContains(results, "(:X rdf:type :U)"));
    }

    private static boolean listContains(List<Triple> list, String strTriple) {
        Triple triple = SSE.parseTriple(strTriple);
        return list.stream().anyMatch(t -> triple.equals(t));
    }

    private static boolean match(Node node, Node slot) {
        return node == null || node == Node.ANY || node.equals(slot);
    }

    private static List<Triple> infOutput(Consumer<StreamRDF> action) {
        CollectorStreamTriples dest = new CollectorStreamTriples();
        StreamRDF stream = RDFSFactory.streamRDFS((StreamRDF)dest, vocab);
        TestStreamRDFS.exec(stream, action);
        return dest.getCollected();
    }

    private static void exec(StreamRDF stream, Consumer<StreamRDF> action) {
        stream.start();
        try {
            action.accept(stream);
        }
        finally {
            stream.finish();
        }
    }

    static {
        node_c = SSE.parseNode(":c");
        node_X = SSE.parseNode(":X");
        node_p = SSE.parseNode(":p");
        node_Q = SSE.parseNode(":Q");
        node_Q2 = SSE.parseNode(":Q2");
        rdfType = NodeConst.nodeRDFType;
    }
}

