/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.rdfs.engine.ConstRDFS;
import org.apache.jena.riot.other.G;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestMiscRDFS {
    private static Graph vocabSC = SSE.parseGraph("(graph (:S rdfs:subClassOf :T))");
    private static Graph dataSC = SSE.parseGraph("(graph (:x rdf:type :S))");
    private static Graph vocabDomain = SSE.parseGraph("(graph (:p rdfs:domain :D) )");
    private static Graph dataDomain = SSE.parseGraph("(graph (:x :p 123))");
    private static Graph vocabDomainSC = SSE.parseGraph("(graph (:p rdfs:domain :R) (:R rdfs:subClassOf :T) )");
    private static Graph dataDomainSC = SSE.parseGraph("(graph (:x :p 123))");
    private static Graph vocabRangeSC = SSE.parseGraph("(graph (:q rdfs:domain :R) (:p rdfs:domain :R0) (:R rdfs:subClassOf :T) )");
    private static Graph dataRangeSC = SSE.parseGraph("(graph (:x :p 123) (:y :q :z))");

    private static Node node(String str2) {
        return SSE.parseNode(str2);
    }

    private static void exactlyOne(Graph graph, Node s, Node p, Node o) {
        G.getOne(graph, s, p, o);
    }

    private static long count(Graph graph, Node s, Node p, Node o) {
        return Iter.count(graph.find(s, p, o));
    }

    private static long count(DatasetGraph dsg, Node g, Node s, Node p, Node o) {
        return Iter.count(dsg.find(g, s, p, o));
    }

    @Test
    public void emptyDataEmptyVocab() {
        Graph vocab = GraphFactory.createDefaultGraph();
        Graph data = GraphFactory.createDefaultGraph();
        Graph rdfs = RDFSFactory.graphRDFS(data, vocab);
        Assert.assertTrue((boolean)rdfs.isEmpty());
        Assert.assertFalse((boolean)rdfs.contains(ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.ANY));
        Assert.assertEquals((long)0L, (long)TestMiscRDFS.count(rdfs, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.ANY));
    }

    @Test
    public void domainOnly() {
        Graph rdfs = RDFSFactory.graphRDFS(dataDomain, vocabDomain);
        TestMiscRDFS.exactlyOne(rdfs, null, ConstRDFS.rdfType, TestMiscRDFS.node(":D"));
        Assert.assertEquals((long)2L, (long)TestMiscRDFS.count(rdfs, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.ANY));
    }

    @Test
    public void domainST() {
        Graph rdfs = RDFSFactory.graphRDFS(dataDomainSC, vocabDomainSC);
        TestMiscRDFS.exactlyOne(rdfs, null, ConstRDFS.rdfType, TestMiscRDFS.node(":T"));
        TestMiscRDFS.exactlyOne(rdfs, null, ConstRDFS.rdfType, TestMiscRDFS.node(":R"));
        TestMiscRDFS.exactlyOne(rdfs, null, null, TestMiscRDFS.node(":R"));
        Assert.assertEquals((long)3L, (long)TestMiscRDFS.count(rdfs, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.ANY));
    }

    @Test
    public void rangeST() {
        Graph rdfs = RDFSFactory.graphRDFS(dataRangeSC, vocabRangeSC);
        TestMiscRDFS.exactlyOne(rdfs, null, ConstRDFS.rdfType, TestMiscRDFS.node(":T"));
        TestMiscRDFS.exactlyOne(rdfs, null, ConstRDFS.rdfType, TestMiscRDFS.node(":R"));
        TestMiscRDFS.exactlyOne(rdfs, null, null, TestMiscRDFS.node(":R"));
        Assert.assertEquals((long)5L, (long)TestMiscRDFS.count(rdfs, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.ANY));
    }

    @Test
    public void dataset() {
        Graph vocab = SSE.parseGraph("(graph (:S rdfs:subClassOf :T))");
        DatasetGraph dsg0 = DatasetGraphFactory.createTxnMem();
        DatasetGraph dsg = RDFSFactory.datasetRDFS(dsg0, vocab);
        dsg.add(Quad.defaultGraphIRI, TestMiscRDFS.node(":s0"), ConstRDFS.rdfType, TestMiscRDFS.node(":S"));
        Assert.assertEquals((long)0L, (long)TestMiscRDFS.count(dsg, Quad.unionGraph, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        Assert.assertEquals((long)2L, (long)TestMiscRDFS.count(dsg, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        dsg.add(TestMiscRDFS.node(":g1"), TestMiscRDFS.node(":s1"), ConstRDFS.rdfType, TestMiscRDFS.node(":S"));
        dsg.add(TestMiscRDFS.node(":g2"), TestMiscRDFS.node(":s2"), ConstRDFS.rdfType, TestMiscRDFS.node(":S"));
        Assert.assertEquals((long)4L, (long)TestMiscRDFS.count(dsg, Quad.unionGraph, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        Assert.assertEquals((long)2L, (long)TestMiscRDFS.count(dsg, Quad.defaultGraphIRI, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        Assert.assertEquals((long)6L, (long)TestMiscRDFS.count(dsg, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        Assert.assertEquals((long)3L, (long)TestMiscRDFS.count(dsg0, ConstRDFS.ANY, ConstRDFS.ANY, ConstRDFS.rdfType, ConstRDFS.ANY));
        Assert.assertEquals((long)1L, (long)Iter.count(dsg.findNG(TestMiscRDFS.node(":g1"), null, null, TestMiscRDFS.node(":T"))));
        Assert.assertEquals((long)2L, (long)Iter.count(dsg.findNG(TestMiscRDFS.node(":g1"), TestMiscRDFS.node(":s1"), ConstRDFS.rdfType, ConstRDFS.ANY)));
        Graph g = dsg.getDefaultGraph();
        TestMiscRDFS.exactlyOne(g, ConstRDFS.ANY, ConstRDFS.ANY, TestMiscRDFS.node(":S"));
        TestMiscRDFS.exactlyOne(g, ConstRDFS.ANY, ConstRDFS.ANY, TestMiscRDFS.node(":T"));
    }
}

