/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import java.io.PrintStream;
import java.util.List;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.atlas.lib.StreamOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.LibTestRDFS;
import org.apache.jena.rdfs.SetupRDFS;
import org.apache.jena.rdfs.engine.ConstRDFS;
import org.apache.jena.rdfs.setup.MatchVocabRDFS;
import org.apache.jena.riot.RDFDataMgr;
import org.junit.Assert;
import org.junit.Test;

public class TestMatchVocab {
    static final String DIR = "testing/RDFS";
    static final String VOCAB_FILE = "testing/RDFS/rdfs-vocab.ttl";
    private static final String RULES_FILE_BWD = "testing/RDFS/rdfs-min-backwards.rules";
    private static final String RULES_FILE_FWD = "testing/RDFS/rdfs-min.rules";
    private static final String RULES_FILE = "testing/RDFS/rdfs-min.rules";
    private static Graph referenceGraph;
    protected static Graph vocab;
    protected static MatchVocabRDFS matchVocab;
    protected static SetupRDFS setup;
    private static PrintStream out;

    @Test
    public void matchVocab_01() {
        this.test(LibTestRDFS.node("T"), ConstRDFS.rdfsSubClassOf, null);
    }

    @Test
    public void matchVocab_02() {
        this.test(null, ConstRDFS.rdfsSubClassOf, null);
    }

    @Test
    public void matchVocab_03() {
        this.test(null, ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("T2"));
    }

    @Test
    public void matchVocab_04() {
        this.test(LibTestRDFS.node("T"), ConstRDFS.rdfsSubClassOf, null);
    }

    @Test
    public void matchVocab_05() {
        this.test(LibTestRDFS.node("T"), ConstRDFS.rdfsSubClassOf, LibTestRDFS.node("T"));
    }

    @Test
    public void matchVocab_10() {
        this.test(LibTestRDFS.node("T"), null, null);
    }

    @Test
    public void matchVocab_11() {
        this.test(null, null, LibTestRDFS.node("T2"));
    }

    @Test
    public void matchVocab_12() {
        this.test(null, null, LibTestRDFS.node("U"));
    }

    @Test
    public void matchVocab_20() {
        this.test(LibTestRDFS.node("NONE"), null, null);
    }

    @Test
    public void matchVocab_21() {
        this.test(null, null, LibTestRDFS.node("NONE"));
    }

    @Test
    public void matchVocab_30() {
        this.test(null, ConstRDFS.rdfsDomain, null);
    }

    @Test
    public void matchVocab_31() {
        this.test(null, ConstRDFS.rdfsRange, null);
    }

    @Test
    public void matchVocab_40() {
        this.test(null, ConstRDFS.rdfsSubPropertyOf, LibTestRDFS.node("T2"));
    }

    @Test
    public void matchVocab_99() {
        this.test(null, null, null);
    }

    private void test(Node s, Node p, Node o) {
        List<Triple> actual;
        String label = "find(" + s + ", " + p + ", " + o + ")";
        List<Triple> expected = LibTestRDFS.findInGraph(referenceGraph, s, p, o);
        boolean b = ListUtils.equalsUnordered(expected, actual = this.match(s, p, o));
        if (!b) {
            out.println("Fail: " + label);
            LibTestRDFS.printDiff(out, expected, actual);
        }
        Assert.assertTrue((String)label, (boolean)b);
    }

    private List<Triple> match(Node s, Node p, Node o) {
        return StreamOps.toList(matchVocab.match(s, p, o));
    }

    static {
        vocab = RDFDataMgr.loadGraph(VOCAB_FILE);
        referenceGraph = LibTestRDFS.createRulesGraph(vocab, vocab, "testing/RDFS/rdfs-min.rules");
        setup = new SetupRDFS(vocab);
        matchVocab = new MatchVocabRDFS(setup);
        out = System.out;
    }
}

