/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfs.assembler.VocabRDFS;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sys.JenaSystem;
import org.junit.Assert;
import org.junit.Test;

public class TestAssemblerRDFS {
    private static final String DIR = "testing/RDFS";
    private static final String PREFIXES;

    @Test
    public void assemble_dataset() {
        Dataset ds = (Dataset)AssemblerUtils.build("testing/RDFS/assembler-rdfs.ttl", VocabRDFS.tDatasetRDFS);
        this.assertSparqlAsk(ds, "{ :z rdf:type :P }");
        this.assertSparqlCount(ds, "{ :z ?p ?o }", 2);
    }

    @Test
    public void assemble_model() {
        Model model = (Model)AssemblerUtils.build("testing/RDFS/assembler-rdfs.ttl", VocabRDFS.tGraphRDFS);
        Dataset ds = DatasetFactory.wrap(model);
        this.assertSparqlAsk(ds, "{ :z rdf:type :P }");
        this.assertSparqlCount(ds, "{ :z ?p ?o }", 2);
    }

    private void assertSparqlAsk(Dataset dataset, String pattern) {
        String queryString = "ASK " + pattern;
        String qs = PREFIXES + queryString;
        Query query2 = QueryFactory.create(qs);
        try (QueryExecution qExec = QueryExecutionFactory.create(query2, dataset);){
            Assert.assertTrue((String)(pattern + " -- "), (boolean)qExec.execAsk());
        }
    }

    private void assertSparqlCount(Dataset dataset, String pattern, int expected) {
        String queryString = "SELECT (count(*) AS ?C) " + pattern;
        String qs = PREFIXES + queryString;
        Query query2 = QueryFactory.create(qs);
        try (QueryExecution qExec = QueryExecutionFactory.create(query2, dataset);){
            ResultSet rs = qExec.execSelect();
            Assert.assertTrue((String)"Result is zero rows", (boolean)rs.hasNext());
            Binding binding = rs.nextBinding();
            Assert.assertTrue((String)"Result not one row", (!rs.hasNext() ? 1 : 0) != 0);
            Node n = binding.get(Var.alloc("C"));
            int actual = NodeValue.makeNode(n).getInteger().intValue();
            Assert.assertEquals((String)("count " + pattern + " -- "), (long)expected, (long)actual);
        }
    }

    static {
        JenaSystem.init();
        PREFIXES = StrUtils.strjoinNL("PREFIX : <http://example/>", "PREFIX rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX rdfs:    <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX sh:      <http://www.w3.org/ns/shacl#>", "PREFIX xsd:     <http://www.w3.org/2001/XMLSchema#>", "");
    }
}

