/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import org.apache.jena.graph.Graph;
import org.apache.jena.rdfs.AbstractTestRDFS;
import org.apache.jena.rdfs.LibTestRDFS;
import org.apache.jena.riot.RDFDataMgr;

public abstract class AbstractTestGraphRDFS
extends AbstractTestRDFS {
    private static final String DIR = "testing/RDFS";
    private static final String DATA_FILE = "testing/RDFS/rdfs-data.ttl";
    private static final String VOCAB_FILE = "testing/RDFS/rdfs-vocab.ttl";
    private static final String RULES_FILE_BWD = "testing/RDFS/rdfs-min-backwards.rules";
    private static final String RULES_FILE_FWD = "testing/RDFS/rdfs-min.rules";
    private static final String RULES_FILE = "testing/RDFS/rdfs-min.rules";
    private static Graph referenceGraph;
    protected static Graph vocab;
    protected static Graph data;

    @Override
    protected final Graph getReferenceGraph() {
        return referenceGraph;
    }

    @Override
    protected String getReferenceLabel() {
        return "InfGraph";
    }

    static {
        vocab = RDFDataMgr.loadGraph(VOCAB_FILE);
        data = RDFDataMgr.loadGraph(DATA_FILE);
        referenceGraph = LibTestRDFS.createRulesGraph(data, vocab, "testing/RDFS/rdfs-min.rules");
    }
}

