/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf_star;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestSPARQLStarParse {
    private static final String PREFIXES = StrUtils.strjoinNL("PREFIX rdf: <" + RDF.getURI() + ">", "PREFIX rdfs:    <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX xsd:     <http://www.w3.org/2001/XMLSchema#>", "PREFIX :    <http://example/>", "");

    private static Query parse(String string) {
        Query query2 = QueryFactory.create(PREFIXES + "SELECT * " + string, Syntax.syntaxARQ);
        return query2;
    }

    private static void parseVars(String string, String ... varNames) {
        Query query2 = TestSPARQLStarParse.parse(string);
        List<String> vars = query2.getResultVars();
        Assert.assertEquals((String)("Wrong number of variables: " + Arrays.asList(varNames) + " : query: " + vars), (long)varNames.length, (long)vars.size());
        for (String v : varNames) {
            Assert.assertTrue((String)("Expected variable ?" + v), (boolean)vars.contains(v));
        }
    }

    @Test
    public void parse_good_1() {
        TestSPARQLStarParse.parse("{ << :s :p :o >> :q 456 }");
    }

    @Test
    public void parse_good_2() {
        TestSPARQLStarParse.parse("{ ?X :q << ?s ?p 123 >> }");
    }

    @Test
    public void parse_good_3() {
        TestSPARQLStarParse.parse("{ << ?s ?p 123 >> :q << ?s ?p 123 >> }");
    }

    @Test
    public void parse_good_4() {
        TestSPARQLStarParse.parse("{ << << :s :p 12 >> ?p << :s :p 34 >> >> :q << ?s ?p 123 >> }");
    }

    @Test
    public void parse_vars_1() {
        TestSPARQLStarParse.parseVars("{ ?X :q << ?s ?p 123 >> }", "X", "s", "p");
    }

    @Test
    public void parse_vars_2() {
        TestSPARQLStarParse.parseVars("{ ?X :q << ?s :p <<:s :q ?q>> >> }", "X", "s", "q");
    }

    @Test
    public void build_1() {
        Triple t = TestSPARQLStarParse.build("{ << :s :p :o >> :q 456 }");
        Assert.assertTrue((boolean)t.isConcrete());
        Assert.assertTrue((boolean)t.getSubject().isNodeTriple());
    }

    @Test
    public void build_2() {
        Triple t = TestSPARQLStarParse.build("{ :x  :q << <<:s ?p :o>> :p 678 >> }");
        Assert.assertFalse((boolean)t.isConcrete());
        Assert.assertTrue((boolean)t.getObject().isNodeTriple());
        Assert.assertTrue((boolean)t.getObject().getTriple().getSubject().isNodeTriple());
    }

    @Test
    public void build_3() {
        Triple t = TestSPARQLStarParse.build("{ << :s ?p :o >> :q 456 }");
        Assert.assertFalse((boolean)t.isConcrete());
        Assert.assertTrue((boolean)t.getSubject().isNodeTriple());
    }

    @Test
    public void queryToOpToQuery_1() {
        TestSPARQLStarParse.queryToOpToQuery("{ << :s :p :o >> :q 456 }");
    }

    @Test
    public void queryToOpToQuery_2() {
        TestSPARQLStarParse.queryToOpToQuery("{ << ?s ?p ?o >> :q 456 }");
    }

    @Test
    public void queryToOpToQuery_3() {
        TestSPARQLStarParse.queryToOpToQuery("{ << << :s :p ?x2 >> ?p << :s :p ?x2 >> >> :q << ?s ?p 123 >> }");
    }

    private static void queryToOpToQuery(String string) {
        Query query2 = TestSPARQLStarParse.parse(string);
        Op op = Algebra.compile(query2);
        query2.getPrefixMapping().clearNsPrefixMap();
        Query query22 = OpAsQuery.asQuery(op);
        Assert.assertEquals((Object)query2, (Object)query22);
    }

    private static Triple build(String string) {
        Query query2 = TestSPARQLStarParse.parse(string);
        Op op = Algebra.compile(query2);
        BasicPattern bgp = ((OpBGP)op).getPattern();
        Assert.assertEquals((long)1L, (long)bgp.size());
        Triple t = bgp.get(0);
        return t;
    }

    @Test(expected=QueryParseException.class)
    public void parse_bad_1() {
        TestSPARQLStarParse.parse("{ <<:s :p :o>> }");
    }

    @Test(expected=QueryParseException.class)
    public void parse_bad_2() {
        TestSPARQLStarParse.parse("{ ?X << :s :p 123 >> ?Z }");
    }

    @Test(expected=QueryParseException.class)
    public void parse_bad_3() {
        TestSPARQLStarParse.parse("{ << :subject << :s :p 12 >> :object >> :q 123 }");
    }
}

