/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.NodeValue;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestQueryCloningEssentials {
    protected Path queryFile;
    protected Query query;
    private static boolean bVerboseWarnings;
    private static boolean bWarnOnUnknownFunction;

    public static Query slowClone(Query query2) {
        String qs = query2.toString();
        return QueryFactory.create(qs, query2.getSyntax());
    }

    public static Query checkedClone(Query query2) {
        Query expected = TestQueryCloningEssentials.slowClone(query2);
        Query actual = query2.cloneQuery();
        Assert.assertEquals((Object)query2, (Object)actual);
        Assert.assertEquals((Object)expected, (Object)actual);
        Query again = TestQueryCloningEssentials.slowClone(actual);
        Assert.assertEquals((Object)query2, (Object)again);
        return actual;
    }

    public TestQueryCloningEssentials(Path queryFile, Query query2) {
        this.queryFile = queryFile;
        this.query = query2;
    }

    public static void beforeClass() {
        bVerboseWarnings = NodeValue.VerboseWarnings;
        bWarnOnUnknownFunction = E_Function.WarnOnUnknownFunction;
        NodeValue.VerboseWarnings = false;
        E_Function.WarnOnUnknownFunction = false;
    }

    @AfterClass
    public static void afterClass() {
        NodeValue.VerboseWarnings = bVerboseWarnings;
        E_Function.WarnOnUnknownFunction = bWarnOnUnknownFunction;
    }

    @Test
    public void runTest() {
        TestQueryCloningEssentials.checkedClone(this.query);
    }

    @Parameterized.Parameters(name="Query.clone {0}")
    public static Collection<Object[]> generateTestParams() throws Exception {
        TestQueryCloningEssentials.beforeClass();
        final List<String> exclusions = Arrays.asList(new String[0]);
        Path startPath = Paths.get("./testing/ARQ", new String[0]).toAbsolutePath().normalize();
        final PathMatcher pathMatcher = startPath.getFileSystem().getPathMatcher("glob:**/*.rq");
        final ArrayList<Object[]> testParams = new ArrayList<Object[]>();
        Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                boolean isExcluded;
                if (pathMatcher.matches(file) && !(isExcluded = exclusions.stream().anyMatch(suffix -> file.toString().endsWith((String)suffix)))) {
                    String queryStr = Files.lines(file).collect(Collectors.joining("\n"));
                    try {
                        Query query2 = QueryFactory.create(queryStr);
                        testParams.add(new Object[]{file, query2});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return testParams;
    }
}

