/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.concurrent.TimeUnit;
import org.apache.jena.ext.com.google.common.base.Stopwatch;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.TestQueryCloningEssentials;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestQueryCloningCornerCases {
    public void benchmarkQueryClone() {
        String str2 = "SELECT * { ?s ?p ?o }";
        int n = 1000000;
        Query q = QueryFactory.create(str2);
        for (int i = 0; i < n; ++i) {
            TestQueryCloningEssentials.slowClone(q);
            q.cloneQuery();
        }
        Stopwatch printParseSw = Stopwatch.createStarted();
        for (int i = 0; i < n; ++i) {
            TestQueryCloningEssentials.slowClone(q);
        }
        printParseSw.stop();
        Stopwatch transformSw = Stopwatch.createStarted();
        for (int i = 0; i < n; ++i) {
            q.cloneQuery();
        }
        transformSw.stop();
        double qpsPrintParse = (double)n / ((double)printParseSw.elapsed(TimeUnit.MILLISECONDS) * 0.001);
        double qpsTransform = (double)n / ((double)transformSw.elapsed(TimeUnit.MILLISECONDS) * 0.001);
        System.out.println("Queries/Second [Print-Parse: " + qpsPrintParse + "], [Transform: " + qpsTransform + "]");
    }

    @Test
    public void testCloneOfDataAndPathBlocks() {
        String str2 = "PREFIX eg: <http://www.example.org/> SELECT * { ?s eg:foo/eg:bar ?o VALUES (?s ?o) { (eg:baz 1) } }";
        Query query2 = QueryFactory.create(str2);
        Query clone = TestQueryCloningEssentials.checkedClone(query2);
        Query cloneOfClone = clone.cloneQuery();
        Element elt = (ElementPathBlock)((ElementGroup)cloneOfClone.getQueryPattern()).get(0);
        ((ElementPathBlock)elt).addTriple(new Triple(RDF.Nodes.type, RDF.Nodes.type, RDF.Nodes.Property));
        Assert.assertNotEquals((Object)elt, (Object)query2);
        Assert.assertEquals((Object)query2, (Object)clone);
        cloneOfClone = clone.cloneQuery();
        elt = (ElementData)((ElementGroup)cloneOfClone.getQueryPattern()).get(1);
        ((ElementData)elt).getRows().add(BindingFactory.empty());
        Assert.assertNotEquals((Object)query2, (Object)cloneOfClone);
        Assert.assertEquals((Object)query2, (Object)clone);
    }

    @Test
    public void testCloneOfValuesDataBlock() {
        String str2 = "PREFIX eg: <http://www.example.org/> SELECT * { ?s eg:foo/eg:bar ?o } VALUES (?s ?o) { (eg:baz 1) }";
        Query query2 = QueryFactory.create(str2);
        Query clone = TestQueryCloningEssentials.checkedClone(query2);
        clone.getValuesData().clear();
        Assert.assertEquals((long)0L, (long)clone.getValuesData().size());
        Assert.assertNotEquals((long)0L, (long)query2.getValuesData().size());
        clone.getValuesVariables().clear();
        Assert.assertEquals((long)0L, (long)clone.getValuesVariables().size());
        Assert.assertNotEquals((long)0L, (long)query2.getValuesVariables().size());
    }
}

