/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.irix.IRIx;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.junit.Assert;
import org.junit.Test;

public class TestParameterizedSparqlString {
    private void test(ParameterizedSparqlString query2, String[] expected, String[] notExpected) {
        String command = query2.toString();
        for (String x : expected) {
            Assert.assertTrue((boolean)command.contains(x));
        }
        for (String x : notExpected) {
            Assert.assertFalse((boolean)command.contains(x));
        }
    }

    private Query testAsQuery(ParameterizedSparqlString query2) {
        return query2.asQuery();
    }

    private UpdateRequest testAsUpdate(ParameterizedSparqlString update2) {
        return update2.asUpdate();
    }

    @Test
    public void test_param_string_constructor_1() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        Assert.assertEquals((Object)"", (Object)query2.getCommandText());
    }

    @Test
    public void test_param_string_constructor_2() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString((String)null);
        Assert.assertEquals((Object)"", (Object)query2.getCommandText());
    }

    @Test
    public void test_param_string_constructor_3() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString("", "http://example.org");
        Assert.assertEquals((Object)"http://example.org", (Object)query2.getBaseUri());
    }

    @Test
    public void test_param_string_constructor_4() {
        QuerySolutionMap map = new QuerySolutionMap();
        Resource r = ResourceFactory.createResource("http://example.org");
        map.add("s", r);
        ParameterizedSparqlString query2 = new ParameterizedSparqlString("", map);
        Assert.assertEquals((Object)r.asNode(), (Object)query2.getParam("s"));
    }

    @Test
    public void test_param_string_constructor_5() {
        QuerySolutionMap map = new QuerySolutionMap();
        Resource r = ResourceFactory.createResource("http://example.org");
        map.add("s", r);
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(map);
        Assert.assertEquals((Object)r.asNode(), (Object)query2.getParam("s"));
    }

    @Test
    public void test_param_string_constructor_6() {
        QuerySolutionMap map = new QuerySolutionMap();
        Resource r = ResourceFactory.createResource("http://example.org");
        map.add("s", r);
        Literal l = ResourceFactory.createPlainLiteral("example");
        map.add("o", l);
        ParameterizedSparqlString query2 = new ParameterizedSparqlString("", map);
        Assert.assertEquals((Object)r.asNode(), (Object)query2.getParam("s"));
        Assert.assertEquals((Object)l.asNode(), (Object)query2.getParam("o"));
    }

    @Test
    public void test_param_string_constructor_7() {
        QuerySolutionMap map = new QuerySolutionMap();
        Resource r = ResourceFactory.createResource("http://example.org");
        map.add("s", r);
        Literal l = ResourceFactory.createPlainLiteral("example");
        map.add("o", l);
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(map);
        Assert.assertEquals((Object)r.asNode(), (Object)query2.getParam("s"));
        Assert.assertEquals((Object)l.asNode(), (Object)query2.getParam("o"));
    }

    @Test
    public void test_param_string_constructor_8() {
        PrefixMappingImpl prefixes = new PrefixMappingImpl();
        prefixes.setNsPrefix("ex", "http://example.org");
        ParameterizedSparqlString query2 = new ParameterizedSparqlString("", (PrefixMapping)prefixes);
        Assert.assertEquals((Object)prefixes.getNsPrefixURI("ex"), (Object)query2.getNsPrefixURI("ex"));
    }

    @Test
    public void test_param_string_constructor_9() {
        PrefixMappingImpl prefixes = new PrefixMappingImpl();
        prefixes.setNsPrefix("ex", "http://example.org");
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(prefixes);
        Assert.assertEquals((Object)prefixes.getNsPrefixURI("ex"), (Object)query2.getNsPrefixURI("ex"));
    }

    @Test
    public void test_param_string_iri_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        this.test(query2, new String[]{"<http://example.org>"}, new String[]{"?s"});
    }

    @Test
    public void test_param_string_iri_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("p", "http://example.org");
        this.test(query2, new String[]{"<http://example.org>"}, new String[]{"?p"});
    }

    @Test
    public void test_param_string_iri_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("o", "http://example.org");
        this.test(query2, new String[]{"<http://example.org>"}, new String[]{"?o"});
    }

    @Test
    public void test_param_string_iri_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . ?s a ?type }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        this.test(query2, new String[]{"<http://example.org>"}, new String[]{"?s"});
    }

    @Test
    public void test_param_string_iri_5() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setIri("p", "http://predicate");
        this.test(query2, new String[]{"<http://example.org>", "<http://predicate>"}, new String[]{"?s", "?p"});
    }

    @Test
    public void test_param_string_bnode_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "_:blankNodeID");
        this.test(query2, new String[]{"<_:blankNodeID>"}, new String[]{"?s"});
    }

    @Test
    public void test_param_string_bnode_2() {
        String cmdText = "INSERT { GRAPH <target> { ?node a:p ?o . } } WHERE { ?node a:p ?o . }";
        ParameterizedSparqlString update2 = new ParameterizedSparqlString(cmdText);
        update2.setIri("node", "_:blankNodeID");
        this.test(update2, new String[]{"<_:blankNodeID>"}, new String[]{"?node"});
    }

    @Test
    public void test_param_string_bnode_3() {
        Model model = ModelFactory.createDefaultModel();
        Resource bnode2 = model.createResource();
        bnode2.addProperty(RDF.type, OWL.Thing);
        Assert.assertEquals((long)1L, (long)model.size());
        Dataset ds = DatasetFactory.wrap(model);
        ParameterizedSparqlString pq = new ParameterizedSparqlString();
        pq.setCommandText("SELECT * WHERE { ?s ?p ?o }");
        pq.setIri("s", "_:" + bnode2.getId());
        Query q = pq.asQuery();
        try (QueryExecution qe = QueryExecutionFactory.create(q, ds);){
            ResultSet rset2 = qe.execSelect();
            Assert.assertEquals((long)1L, (long)ResultSetFormatter.consume(rset2));
        }
        ParameterizedSparqlString s = new ParameterizedSparqlString();
        s.setCommandText("INSERT { ?o ?p ?s } WHERE { ?s ?p ?o }");
        s.setIri("s", "_:" + bnode2.getId());
        UpdateRequest query2 = s.asUpdate();
        UpdateProcessor proc = UpdateExecutionFactory.create(query2, ds);
        proc.execute();
        Assert.assertEquals((long)1L, (long)model.listStatements(bnode2, null, (RDFNode)null).toList().size());
        Assert.assertEquals((long)0L, (long)model.listStatements(null, null, bnode2).toList().size());
    }

    @Test
    public void test_param_string_mixed_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setIri("p", "http://predicate");
        query2.setLiteral("o", true);
        this.test(query2, new String[]{"<http://example.org>", "<http://predicate>", "true"}, new String[]{"?s", "?p", "?o"});
    }

    @Test
    public void test_param_string_string_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setIri("p", "http://predicate");
        query2.setLiteral("o", "test");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test\" . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_string_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setIri("p", "http://predicate");
        query2.setLiteral("o", "A \"test\" string");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"A \\\"test\\\" string\" . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_string_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setIri("p", "http://predicate");
        query2.setLiteral("o", "Show me the $!");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"Show me the $!\" . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_string_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setIri("p", "http://predicate");
        query2.setLiteral("o", "A multi\nline string");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"A multi\\nline string\" . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_string_5() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setIri("p", "http://predicate");
        query2.setLiteral("o", "A tabby\tstring");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"A tabby\\tstring\" . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_string_6() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setIri("p", "http://predicate");
        query2.setLiteral("o", "A test's test");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"A test\\'s test\" . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_string_7() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setIri("p", "http://predicate");
        query2.setLiteral("o", "test a\\b");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test a\\\\b\" . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_boolean_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", true);
        this.test(query2, new String[]{"true"}, new String[]{"?o", XSD.xboolean.toString()});
    }

    @Test
    public void test_param_string_boolean_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", false);
        this.test(query2, new String[]{"false"}, new String[]{"?o", XSD.xboolean.toString()});
    }

    @Test
    public void test_param_string_boolean_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xboolean.toString()));
        this.test(query2, new String[]{"xyz", XSD.xboolean.toString()}, new String[]{"?o"});
    }

    @Test
    public void test_param_string_boolean_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, true);
        this.test(query2, new String[]{"true"}, new String[]{"? ", XSD.xboolean.toString()});
    }

    @Test
    public void test_param_string_boolean_5() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, false);
        this.test(query2, new String[]{"false"}, new String[]{"? ", XSD.xboolean.toString()});
    }

    @Test
    public void test_param_string_boolean_6() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xboolean.toString()));
        this.test(query2, new String[]{"xyz", XSD.xboolean.toString()}, new String[]{"? "});
    }

    @Test
    public void test_param_string_int_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", 1234);
        this.test(query2, new String[]{"1234"}, new String[]{"?o", XSD.integer.toString()});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_int_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", 3000000000L);
        this.test(query2, new String[]{"3000000000"}, new String[]{"?o", XSD.integer.toString()});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_int_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.integer.toString()));
        this.test(query2, new String[]{"xyz", XSD.integer.toString()}, new String[]{"?o"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_int_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, 1234);
        this.test(query2, new String[]{"1234"}, new String[]{"? ", XSD.integer.toString()});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_int_5() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, 3000000000L);
        this.test(query2, new String[]{"3000000000"}, new String[]{"? ", XSD.integer.toString()});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_int_6() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.integer.toString()));
        this.test(query2, new String[]{"xyz", XSD.integer.toString()}, new String[]{"? "});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_double_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", 123.4);
        this.test(query2, new String[]{"123.4", XSD.xdouble.toString()}, new String[]{"?o"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_double_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", 1.23E7);
        this.test(query2, new String[]{"1.23E7"}, new String[]{"?o", XSD.xdouble.toString()});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_double_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xdouble.toString()));
        this.test(query2, new String[]{"xyz", XSD.xdouble.toString()}, new String[]{"?o"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_double_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, 123.4);
        this.test(query2, new String[]{"123.4", XSD.xdouble.toString()}, new String[]{"? "});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_double_5() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, 1.23E7);
        this.test(query2, new String[]{"1.23E7"}, new String[]{"? ", XSD.xdouble.toString()});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_double_6() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xdouble.toString()));
        this.test(query2, new String[]{"xyz", XSD.xdouble.toString()}, new String[]{"? "});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_float_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", 123.4f);
        this.test(query2, new String[]{"123.4", XSD.xfloat.toString()}, new String[]{"?o"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_float_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, 123.4f);
        this.test(query2, new String[]{"123.4", XSD.xfloat.toString()}, new String[]{"? "});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_date_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        Calendar dt = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        dt.set(2012, 1, 24, 12, 0, 0);
        query2.setLiteral("o", dt);
        this.test(query2, new String[]{"2012-02-24T12:00:00", XSD.dateTime.toString()}, new String[]{"?o"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_date_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.dateTime.toString()));
        this.test(query2, new String[]{"xyz", XSD.dateTime.toString()}, new String[]{"?o"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_date_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        Calendar dt = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        dt.set(2012, 1, 24, 12, 0, 0);
        query2.setLiteral(0, dt);
        this.test(query2, new String[]{"2012-02-24T12:00:00", XSD.dateTime.toString()}, new String[]{"? "});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_date_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.dateTime.toString()));
        this.test(query2, new String[]{"xyz", XSD.dateTime.toString()}, new String[]{"? "});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_lang_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", "hello", "en");
        this.test(query2, new String[]{"hello", "@en"}, new String[]{"?o"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_lang_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("o", "bonjour", "fr");
        this.test(query2, new String[]{"bonjour", "@fr"}, new String[]{"?o"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_lang_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, "hello", "en");
        this.test(query2, new String[]{"hello", "@en"}, new String[]{"? "});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_lang_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral(0, "bonjour", "fr");
        this.test(query2, new String[]{"bonjour", "@fr"}, new String[]{"? "});
        this.testAsQuery(query2);
    }

    @Test(expected=QueryException.class)
    public void test_param_string_bad_1() {
        String cmdText = "Not a query";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        this.testAsQuery(query2);
    }

    @Test(expected=QueryException.class)
    public void test_param_string_simple_bad_1() {
        String cmdText = "SELECT ?s WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        this.test(query2, new String[]{"<http://example.org>"}, new String[]{"?s"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_precedence_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setIri("s", "http://alternate.org");
        this.test(query2, new String[]{"<http://alternate.org>"}, new String[]{"?s", "<http://example.org>"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_precedence_2() {
        String cmdText = "SELECT * WHERE { ? ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri(0, "http://example.org");
        query2.setIri(0, "http://alternate.org");
        this.test(query2, new String[]{"<http://alternate.org>"}, new String[]{"? ", "<http://example.org>"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_name_collision_1() {
        String cmdText = "SELECT * WHERE { ?a ?ab ?abc }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("a", "http://example.org");
        this.test(query2, new String[]{"<http://example.org>", "?ab", "?abc"}, new String[]{"?a "});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_name_collision_2() {
        String cmdText = "SELECT * WHERE { ?abc ?ab ?a. }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("a", "http://example.org");
        this.test(query2, new String[]{"<http://example.org>", "?ab", "?abc"}, new String[]{"?a "});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_name_collision_3() {
        String cmdText = "PREFIX ex: <http://example.org/vocab#> SELECT * WHERE { ?s ex:name ?name }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setLiteral("name", "Bob");
        this.test(query2, new String[]{"Bob"}, new String[]{"?name", "ex:Bob"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_clear_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.clearParam("s");
        this.test(query2, new String[]{"?s"}, new String[]{"<http://example.org>"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_clear_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.clearParams();
        this.test(query2, new String[]{"?s"}, new String[]{"<http://example.org>"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_clear_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri("s", "http://example.org");
        query2.setParam("s", (Node)null);
        this.test(query2, new String[]{"?s"}, new String[]{"<http://example.org>"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_clear_4() {
        String cmdText = "SELECT * WHERE { ? ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri(0, "http://example.org");
        query2.clearParam(0);
        this.test(query2, new String[]{"? "}, new String[]{"<http://example.org>"});
    }

    @Test
    public void test_param_string_clear_5() {
        String cmdText = "SELECT * WHERE { ? ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri(0, "http://example.org");
        query2.clearParams();
        this.test(query2, new String[]{"? "}, new String[]{"<http://example.org>"});
    }

    @Test
    public void test_param_string_clear_6() {
        String cmdText = "SELECT * WHERE { ? ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setIri(0, "http://example.org");
        query2.setParam(0, (Node)null);
        this.test(query2, new String[]{"? "}, new String[]{"<http://example.org>"});
    }

    @Test
    public void test_param_string_prefixes_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setNsPrefix("ex", "http://example.org");
        this.test(query2, new String[]{"PREFIX", "ex:", "<http://example.org>"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_prefixes_2() {
        String cmdText = "SELECT * WHERE { ?s ex:predicate ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setNsPrefix("ex", "http://example.org");
        this.test(query2, new String[]{"PREFIX", "ex:", "<http://example.org>", "ex:predicate"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test(expected=QueryException.class)
    public void test_param_string_prefixes_bad_1() {
        String cmdText = "SELECT * WHERE { ?s ex:predicate ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        this.test(query2, new String[]{"ex:predicate"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_base_1() {
        String cmdText = "SELECT * WHERE { ?s <#predicate> ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setBaseUri("http://example.org");
        this.test(query2, new String[]{"BASE", "<http://example.org>"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_base_bad_1() {
        String cmdText = "SELECT * WHERE { ?s <#predicate> ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        this.test(query2, new String[0], new String[]{"BASE", "<http://example.org>"});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_copy_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        ParameterizedSparqlString copy = query2.copy();
        Assert.assertEquals((Object)cmdText, (Object)copy.getCommandText());
    }

    @Test
    public void test_param_string_copy_2() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.setIri("x", "http://example.org/original");
        ParameterizedSparqlString copy = query2.copy();
        copy.setIri("x", "http://example.org/copy");
        Assert.assertEquals((Object)"http://example.org/original", (Object)query2.getParam("x").toString());
        Assert.assertFalse((boolean)"http://example.org/copy".equals(query2.getParam("x").toString()));
        Assert.assertEquals((Object)"http://example.org/copy", (Object)copy.getParam("x").toString());
        Assert.assertFalse((boolean)"http://example.org/original".equals(copy.getParam("x").toString()));
    }

    @Test
    public void test_param_string_copy_3() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.setNsPrefix("ex", "http://example.org");
        ParameterizedSparqlString copy = query2.copy();
        Assert.assertEquals((Object)"http://example.org", (Object)copy.getNsPrefixURI("ex"));
    }

    @Test
    public void test_param_string_copy_4() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.setBaseUri("http://example.org");
        ParameterizedSparqlString copy = query2.copy();
        Assert.assertEquals((Object)"http://example.org", (Object)copy.getBaseUri());
    }

    @Test
    public void test_param_string_copy_5() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.setIri("x", "http://example.org/original");
        ParameterizedSparqlString copy = query2.copy(false);
        Assert.assertEquals((Object)"http://example.org/original", (Object)query2.getParam("x").toString());
        Assert.assertEquals(null, (Object)copy.getParam("x"));
    }

    @Test
    public void test_param_string_copy_6() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.setNsPrefix("ex", "http://example.org");
        ParameterizedSparqlString copy = query2.copy(true, true, false);
        Assert.assertFalse((boolean)"http://example.org".equals(copy.getNsPrefixURI("ex")));
    }

    @Test
    public void test_param_string_copy_7() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.setIri(0, "http://example.org/original");
        ParameterizedSparqlString copy = query2.copy();
        copy.setIri(0, "http://example.org/copy");
        Assert.assertEquals((Object)"http://example.org/original", (Object)query2.getParam(0).toString());
        Assert.assertFalse((boolean)"http://example.org/copy".equals(query2.getParam(0).toString()));
        Assert.assertEquals((Object)"http://example.org/copy", (Object)copy.getParam(0).toString());
        Assert.assertFalse((boolean)"http://example.org/original".equals(copy.getParam(0).toString()));
    }

    @Test
    public void test_param_string_copy_8() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.setIri(0, "http://example.org/original");
        ParameterizedSparqlString copy = query2.copy(false);
        Assert.assertEquals((Object)"http://example.org/original", (Object)query2.getParam(0).toString());
        Assert.assertEquals(null, (Object)copy.getParam(0));
    }

    @Test
    public void test_param_string_append_1() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ?o }");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "?o"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_2() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.append(true);
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "true"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_3() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.append(123);
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "123"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_4() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.append(123L);
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "123"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_5() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.append(1.23E7);
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "1.23E7"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_iri_1() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ");
        query2.appendIri("http://example.org");
        query2.append(" ?o }");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "<http://example.org>", "?o"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_iri_2() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ");
        query2.appendIri(IRIx.create("http://example.org"));
        query2.append(" ?o }");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "<http://example.org>", "?o"}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_boolean_1() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.appendLiteral(true);
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "true"}, new String[]{XSD.xboolean.toString()});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_boolean_2() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.appendLiteral("xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xboolean.toString()));
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "xyz", XSD.xboolean.toString()}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_integer_1() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.appendLiteral(123);
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "123"}, new String[]{XSD.integer.toString()});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_integer_2() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.appendLiteral("xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.integer.toString()));
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "xyz", XSD.integer.toString()}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_integer_3() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.appendLiteral(123L);
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "123"}, new String[]{XSD.integer.toString()});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_double_1() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.appendLiteral(1.23E7);
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "1.23E7"}, new String[]{XSD.xdouble.toString()});
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_double_2() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.appendLiteral(1.23);
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "1.23", XSD.xdouble.toString()}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_append_double_3() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT *");
        query2.append('\n');
        query2.append("WHERE { ?s ?p ");
        query2.appendLiteral("xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xdouble.toString()));
        query2.append("}");
        this.test(query2, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "xyz", XSD.xdouble.toString()}, new String[0]);
        this.testAsQuery(query2);
    }

    @Test
    public void test_param_string_positional_1() {
        ParameterizedSparqlString query2 = new ParameterizedSparqlString();
        query2.append("SELECT * WHERE { ? ?p ?o }");
        query2.setParam(0, NodeFactory.createURI("http://example.org"));
        this.test(query2, new String[]{"<http://example.org>"}, new String[]{"? "});
    }

    @Test
    public void test_param_string_positional_2() {
        String cmdText = "SELECT * WHERE { ? ? ? . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setParam(0, NodeFactory.createURI("http://example.org"));
        query2.setParam(1, NodeFactory.createURI("http://predicate"));
        query2.setParam(2, NodeFactory.createLiteral("test"));
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test\" . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_positional_3() {
        String cmdText = "SELECT * WHERE { ? ? ? . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setParam(0, NodeFactory.createLiteral("with ? mark"));
        query2.setParam(1, NodeFactory.createURI("http://predicate"));
        query2.setParam(2, NodeFactory.createLiteral("test"));
        Assert.assertEquals((Object)"SELECT * WHERE { \"with ? mark\" <http://predicate> \"test\" . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_positional_4() {
        String cmdText = "SELECT * WHERE { ? ? ? . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setParam(0, NodeFactory.createLiteral("with ? mark"));
        query2.setParam(1, NodeFactory.createLiteral("with ? mark"));
        query2.setParam(2, NodeFactory.createLiteral("test"));
        Assert.assertEquals((Object)"SELECT * WHERE { \"with ? mark\" \"with ? mark\" \"test\" . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_positional_5() {
        String cmdText = "SELECT * WHERE { ? ? ?. }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setParam(0, NodeFactory.createURI("http://example.org"));
        query2.setParam(1, NodeFactory.createURI("http://predicate"));
        query2.setParam(2, NodeFactory.createLiteral("test"));
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test\". }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_positional_6() {
        String cmdText = "SELECT * WHERE { ? ? ?; ?p ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setParam(0, NodeFactory.createURI("http://example.org"));
        query2.setParam(1, NodeFactory.createURI("http://predicate"));
        query2.setParam(2, NodeFactory.createLiteral("test"));
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test\"; ?p ?o . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_positional_7() {
        String cmdText = "SELECT * WHERE { ? ? ?, ?o . }";
        ParameterizedSparqlString query2 = new ParameterizedSparqlString(cmdText);
        query2.setParam(0, NodeFactory.createURI("http://example.org"));
        query2.setParam(1, NodeFactory.createURI("http://predicate"));
        query2.setParam(2, NodeFactory.createLiteral("test"));
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test\", ?o . }", (Object)query2.toString());
    }

    @Test
    public void test_param_string_positional_eligible_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(cmdText);
        Iterator<Integer> iter = pss.getEligiblePositionalParameters();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void test_param_string_positional_eligible_2() {
        String cmdText = "SELECT * WHERE { ? ? ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(cmdText);
        Iterator<Integer> iter = pss.getEligiblePositionalParameters();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void test_param_string_positional_eligible_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?; ?p1 ?, ?. }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(cmdText);
        Iterator<Integer> iter = pss.getEligiblePositionalParameters();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_01() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var2 . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setIri("var2", "hello> } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye>");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_02() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var2 . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setIri("var2", "hello> } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_injection_03() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var2 . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var2", "hello\" } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye>");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_04() {
        String str2 = "PREFIX : <http://example/>\nSELECT * WHERE { <s> <p> ?var2 . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setIri("var2", "hello> . ?s ?p ?o");
        pss.asQuery();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_injection_05() {
        String str2 = "PREFIX : <http://example/>\nSELECT * WHERE { <s> <p> ?var2 . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var2", "hello\" . ?s ?p ?o");
        Query q = pss.asQuery();
        Element el = q.getQueryPattern();
        if (el instanceof ElementTriplesBlock) {
            Assert.assertEquals((long)1L, (long)((ElementTriplesBlock)q.getQueryPattern()).getPattern().size());
        } else if (el instanceof ElementGroup) {
            Assert.assertEquals((long)1L, (long)((ElementGroup)el).getElements().size());
            el = ((ElementGroup)el).getElements().get(0);
            if (el instanceof ElementTriplesBlock) {
                Assert.assertEquals((long)1L, (long)((ElementTriplesBlock)el).getPattern().size());
            }
        }
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_06() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> '?var' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", "hello' . } ; DROP ALL ; INSERT DATA { <s> <p> \"goodbye");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_07() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \"?var\" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_08() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> '?var' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_injection_09() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", "\" . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_10() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", "a");
        pss.setLiteral("var2", "b");
        String first = pss.getVars().next();
        String second = first.equals("var") ? "var2" : "var";
        pss.setLiteral(first, "?" + second);
        pss.setLiteral(second, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_11() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \" ?var \" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_12() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \"some text ?var other text\" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_injection_13() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ' ?var ' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test
    public void test_param_string_injection_14() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> 'some text ?var other text' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_15() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", "a");
        pss.setLiteral("var2", "b");
        String first = pss.getVars().next();
        String second = first.equals("var") ? "var2" : "var";
        pss.setLiteral(first, " ?" + second + " ");
        pss.setLiteral(second, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_non_injection_01() {
        String str2 = "SELECT * { \"subject\" ?var \"object\" . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("var", "predicate");
        pss.toString();
    }

    @Test
    public void test_param_string_non_injection_02() {
        String prefixes = "PREFIX : <http://purl.bdrc.io/ontology/core/>\n PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\n PREFIX text: <http://jena.apache.org/text#>";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("L_name", "\"rgyud bla ma\"");
        map.put("LG_name", "bo-x-ewts");
        String test1 = prefixes + "select ?comment (GROUP_CONCAT(DISTINCT ?comment_type;  SEPARATOR=\" <>\") AS ?comment_types)  ?root_name\nwhere {\n    (?root ?score ?root_name) text:query ?L_name .\n    ?comment :workIsAbout ?root;\n             :workGenre ?g .\n    ?g skos:prefLabel ?comment_type .\n}\ngroup by ?comment ?root_name";
        ParameterizedSparqlString queryStr = new ParameterizedSparqlString(test1);
        queryStr.setLiteral("L_name", (String)map.get("L_name"), (String)map.get("LG_name"));
        queryStr.asQuery();
    }

    @Test
    public void test_param_string_non_injection_03() {
        String prefixes = "PREFIX : <http://purl.bdrc.io/ontology/core/>\n PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\n PREFIX text: <http://jena.apache.org/text#>\n";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("L_name", "\"rgyud bla ma\"");
        map.put("LG_name", "bo-x-ewts");
        String test2 = prefixes + "select ?comment (GROUP_CONCAT(DISTINCT ?comment_type;  SEPARATOR=\" <>\") AS ?comment_types)  ?root_name\nwhere {\n    (?root ?score ?root_name) text:query ?L_name .\n    ?comment :workIsAbout ?root;\n             :workGenre ?g .\n    ?g skos:prefLabel ?comment_type .\n    FILTER (contains(?comment_type, \"commentary\" ))\n}\ngroup by ?comment ?root_name";
        ParameterizedSparqlString queryStr2 = new ParameterizedSparqlString(test2);
        queryStr2.setLiteral("L_name", (String)map.get("L_name"), (String)map.get("LG_name"));
        queryStr2.asQuery();
    }

    @Test(expected=ARQException.class)
    public void test_param_string_positional_injection_01() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?v . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setIri(0, "hello> } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye>");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_positional_injection_02() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setIri(0, "hello> } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_positional_injection_03() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, "hello\" } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye>");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test(expected=ARQException.class)
    public void test_param_string_positional_injection_04() {
        String str2 = "PREFIX : <http://example/>\nSELECT * WHERE { <s> <p> ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setIri(0, "hello> . ?s ?p ?o");
        pss.asQuery();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_positional_injection_05() {
        String str2 = "PREFIX : <http://example/>\nSELECT * WHERE { <s> <p> ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, "hello\" . ?s ?p ?o");
        Query q = pss.asQuery();
        Element el = q.getQueryPattern();
        if (el instanceof ElementTriplesBlock) {
            Assert.assertEquals((long)1L, (long)((ElementTriplesBlock)q.getQueryPattern()).getPattern().size());
        } else if (el instanceof ElementGroup) {
            Assert.assertEquals((long)1L, (long)((ElementGroup)el).getElements().size());
            el = ((ElementGroup)el).getElements().get(0);
            if (el instanceof ElementTriplesBlock) {
                Assert.assertEquals((long)1L, (long)((ElementTriplesBlock)el).getPattern().size());
            }
        }
    }

    @Test
    public void test_param_string_positional_injection_06() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> '?' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, "hello' . } ; DROP ALL ; INSERT DATA { <s> <p> \"goodbye");
        Assert.assertFalse((boolean)pss.getEligiblePositionalParameters().hasNext());
    }

    @Test
    public void test_param_string_positional_injection_07() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \"?\" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        Assert.assertFalse((boolean)pss.getEligiblePositionalParameters().hasNext());
    }

    @Test
    public void test_param_string_positional_injection_08() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> '?' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        Assert.assertFalse((boolean)pss.getEligiblePositionalParameters().hasNext());
    }

    @Test
    public void test_param_string_positional_injection_09() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ? }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, "\" . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test
    public void test_param_string_positional_injection_10() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ? }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, "?");
        pss.setLiteral(1, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        Iterator<Integer> params = pss.getEligiblePositionalParameters();
        Assert.assertTrue((boolean)params.hasNext());
        params.next();
        Assert.assertFalse((boolean)params.hasNext());
        UpdateRequest u = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)u.getOperations().size());
    }

    @Test(expected=ARQException.class)
    public void test_param_string_positional_injection_11() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \" ? \" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_positional_injection_12() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \"some text ? other text\" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_positional_injection_13() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ' ? ' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test
    public void test_param_string_positional_injection_14() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> 'some text ? other text' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test
    public void test_param_string_positional_injection_15() {
        String str2 = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ? }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, " ? ");
        pss.setLiteral(1, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        Iterator<Integer> params = pss.getEligiblePositionalParameters();
        Assert.assertTrue((boolean)params.hasNext());
        params.next();
        Assert.assertFalse((boolean)params.hasNext());
        UpdateRequest u = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)u.getOperations().size());
    }

    @Test
    public void test_param_string_positional_non_injection_01() {
        String str2 = "SELECT * { \"subject\" ? \"object\" . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral(0, "predicate");
        pss.toString();
    }

    @Test
    public void test_param_string_bug_01() {
        String str2 = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("o", "has$sign");
        pss.toString();
    }

    @Test
    public void test_param_string_bug_02() {
        String str2 = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("o", "has$1sign");
        pss.toString();
    }

    @Test
    public void test_param_string_bug_03() {
        String str2 = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("o", "has$5sign");
        pss.toString();
    }

    @Test
    public void test_param_string_bug_04() {
        String str2 = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setLiteral("o", "has $9 sign");
        pss.toString();
    }

    @Test
    public void test_set_values_item() {
        String str2 = "SELECT * WHERE { VALUES ?o {?objs} ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setValues("objs", ResourceFactory.createPlainLiteral("test"));
        String exp = "SELECT * WHERE { VALUES ?o {(\"test\")} ?s ?p ?o }";
        String res = pss.toString();
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test
    public void test_set_values_item2() {
        String str2 = "SELECT * WHERE { VALUES $o {$objs} $s $p $o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setValues("objs", ResourceFactory.createPlainLiteral("test"));
        String exp = "SELECT * WHERE { VALUES $o {(\"test\")} $s $p $o }";
        String res = pss.toString();
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test
    public void test_set_values_item_missing_values() {
        String str2 = "SELECT * WHERE { ?o {?objs} ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setValues("objs", ResourceFactory.createPlainLiteral("test"));
        String exp = "SELECT * WHERE { ?o {?objs} ?s ?p ?o }";
        String res = pss.toString();
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test
    public void test_set_values_item_missing_braces() {
        String str2 = "SELECT * WHERE { VALUES ?o ?objs ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setValues("objs", ResourceFactory.createPlainLiteral("test"));
        String exp = "SELECT * WHERE { VALUES ?o ?objs ?s ?p ?o }";
        String res = pss.toString();
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test
    public void test_set_values_item_missing_valueName() {
        String str2 = "SELECT * WHERE { VALUES ?o {?objs} ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setValues("props", ResourceFactory.createPlainLiteral("test"));
        String exp = "SELECT * WHERE { VALUES ?o {?objs} ?s ?p ?o }";
        String res = pss.toString();
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test
    public void test_set_values_items_parenthesis() {
        String str2 = "SELECT * WHERE { VALUES (?o) {?objs} ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        ArrayList<Literal> objs = new ArrayList<Literal>();
        objs.add(ResourceFactory.createPlainLiteral("obj_A"));
        objs.add(ResourceFactory.createPlainLiteral("obj_B"));
        pss.setValues("objs", objs);
        String exp = "SELECT * WHERE { VALUES (?o) {(\"obj_A\") (\"obj_B\")} ?s ?p ?o }";
        String res = pss.toString();
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test
    public void test_empty_list() {
        String str2 = "SELECT * WHERE { VALUES (?o) {?objs} ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        ArrayList objs = new ArrayList();
        pss.setValues("objs", objs);
        String exp = "SELECT * WHERE { VALUES (?o) {} ?s ?p ?o }";
        String res = pss.toString();
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test
    public void test_set_values_multiple_variables() {
        String str2 = "SELECT * WHERE { VALUES (?p ?o) {?vars} ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        ArrayList<RDFNode> vars = new ArrayList<RDFNode>();
        vars.add(ResourceFactory.createProperty("http://example.org/prop_A"));
        vars.add(ResourceFactory.createPlainLiteral("obj_A"));
        pss.setValues("vars", vars);
        String exp = "SELECT * WHERE { VALUES (?p ?o) {(<http://example.org/prop_A> \"obj_A\")} ?s ?p ?o }";
        String res = pss.toString();
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test(expected=ARQException.class)
    public void test_set_values_multiple_variables_too_few() {
        String str2 = "SELECT * WHERE { VALUES (?p ?o) {?vars} ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        ArrayList<Property> vars = new ArrayList<Property>();
        vars.add(ResourceFactory.createProperty("http://example.org/prop_A"));
        pss.setValues("vars", vars);
        pss.toString();
        Assert.fail((String)"Attempt to insert incorrect number of values.");
    }

    @Test(expected=ARQException.class)
    public void test_set_values_multiple_variables_too_many() {
        String str2 = "SELECT * WHERE { VALUES (?p ?o) {?vars} ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        ArrayList<RDFNode> vars = new ArrayList<RDFNode>();
        vars.add(ResourceFactory.createProperty("http://example.org/prop_A"));
        vars.add(ResourceFactory.createPlainLiteral("obj_A"));
        vars.add(ResourceFactory.createPlainLiteral("obj_A"));
        pss.setValues("vars", vars);
        pss.toString();
        Assert.fail((String)"Attempt to insert incorrect number of values.");
    }

    @Test
    public void test_set_values_multi_var() {
        String str2 = "SELECT * WHERE { VALUES ?p {?props} VALUES ?o {?objs} ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        ArrayList<Literal> objs = new ArrayList<Literal>();
        objs.add(ResourceFactory.createPlainLiteral("obj_A"));
        objs.add(ResourceFactory.createPlainLiteral("obj_B"));
        pss.setValues("objs", objs);
        ArrayList<Property> props = new ArrayList<Property>();
        props.add(ResourceFactory.createProperty("http://example.org/prop_A"));
        props.add(ResourceFactory.createProperty("http://example.org/prop_B"));
        pss.setValues("props", props);
        String exp = "SELECT * WHERE { VALUES ?p {(<http://example.org/prop_A>) (<http://example.org/prop_B>)} VALUES ?o {(\"obj_A\") (\"obj_B\")} ?s ?p ?o }";
        String res = pss.toString();
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test
    public void test_set_values_grouped_var() {
        String str2 = "SELECT * WHERE { VALUES (?p ?o) {?vars} ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        ArrayList<List<? extends RDFNode>> vars = new ArrayList<List<? extends RDFNode>>();
        ArrayList<RDFNode> objsA = new ArrayList<RDFNode>();
        objsA.add(ResourceFactory.createProperty("http://example.org/prop_A"));
        objsA.add(ResourceFactory.createPlainLiteral("obj_A"));
        vars.add(objsA);
        ArrayList<RDFNode> objsB = new ArrayList<RDFNode>();
        objsB.add(ResourceFactory.createProperty("http://example.org/prop_B"));
        objsB.add(ResourceFactory.createPlainLiteral("obj_B"));
        vars.add(objsB);
        pss.setRowValues("vars", vars);
        String exp = "SELECT * WHERE { VALUES (?p ?o) {(<http://example.org/prop_A> \"obj_A\") (<http://example.org/prop_B> \"obj_B\")} ?s ?p ?o }";
        String res = pss.toString();
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test(expected=ARQException.class)
    public void test_set_values_uri_injection() {
        String str2 = "PREFIX : <http://example/>\nSELECT * WHERE { VALUES ?obj {?objVar} <s> <p> ?obj . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str2);
        pss.setValues(str2, ResourceFactory.createResource("<http://example.org/obj_A>"));
        pss.toString();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_extract_target_vars() {
        String cmd2 = "SELECT * WHERE { VALUES ?o {?objs} ?s ?p ?o }";
        String valueName = "objs";
        Object[] res = ParameterizedSparqlString.extractTargetVars(cmd2, valueName);
        Object[] exp = new String[]{"o"};
        Assert.assertArrayEquals((Object[])exp, (Object[])res);
    }

    @Test
    public void test_extract_two_target_vars() {
        String cmd2 = "SELECT * WHERE { VALUES(?p ?o){?valuesName} ?s ?p ?o }";
        String valueName = "valuesName";
        Object[] res = ParameterizedSparqlString.extractTargetVars(cmd2, valueName);
        Object[] exp = new String[]{"p", "o"};
        Assert.assertArrayEquals((Object[])exp, (Object[])res);
    }

    @Test
    public void test_extract_multiple_target_vars() {
        String cmd2 = "SELECT * WHERE { VALUES ?p {?props} VALUES ?o {?objs} ?s ?p ?o }";
        String valueName = "objs";
        Object[] res = ParameterizedSparqlString.extractTargetVars(cmd2, valueName);
        Object[] exp = new String[]{"o"};
        Assert.assertArrayEquals((Object[])exp, (Object[])res);
    }

    @Test
    public void test_extract_target_vars_missing_target() {
        String cmd2 = "SELECT * WHERE { VALUES ?o {} ?s ?p ?o }";
        String valueName = "objs";
        Object[] res = ParameterizedSparqlString.extractTargetVars(cmd2, valueName);
        Object[] exp = new String[]{};
        Assert.assertArrayEquals((Object[])exp, (Object[])res);
    }

    @Test
    public void test_extract_target_vars_missing_brace() {
        String cmd2 = "SELECT * WHERE { VALUES ?o ?objs} ?s ?p ?o }";
        String valueName = "objs";
        Object[] res = ParameterizedSparqlString.extractTargetVars(cmd2, valueName);
        Object[] exp = new String[]{};
        Assert.assertArrayEquals((Object[])exp, (Object[])res);
    }

    @Test
    public void test_extract_multiple_target_vars_missing_brace() {
        String cmd2 = "SELECT * WHERE { VALUES ?p {?props} VALUES ?o ?objs} ?s ?p ?o }";
        String valueName = "objs";
        Object[] res = ParameterizedSparqlString.extractTargetVars(cmd2, valueName);
        Object[] exp = new String[]{};
        Assert.assertArrayEquals((Object[])exp, (Object[])res);
    }

    @Test
    public void test_extract_target_vars_missing_values() {
        String cmd2 = "SELECT * WHERE { ?o {?objs} ?s ?p ?o }";
        String valueName = "objs";
        Object[] res = ParameterizedSparqlString.extractTargetVars(cmd2, valueName);
        Object[] exp = new String[]{};
        Assert.assertArrayEquals((Object[])exp, (Object[])res);
    }

    @Test
    public void test_extract_multiple_target_vars_missing_values() {
        String cmd2 = "SELECT * WHERE { VALUES ?p {?props} ?o {?objs} ?s ?p ?o }";
        String valueName = "objs";
        Object[] res = ParameterizedSparqlString.extractTargetVars(cmd2, valueName);
        Object[] exp = new String[]{};
        Assert.assertArrayEquals((Object[])exp, (Object[])res);
    }

    @Test
    public void test_extract_multiple_target_vars_no_braces() {
        String cmd2 = "SELECT * WHERE { VALUES ?p ?props ?o ?objs ?s ?p ?o }";
        String valueName = "objs";
        Object[] res = ParameterizedSparqlString.extractTargetVars(cmd2, valueName);
        Object[] exp = new String[]{};
        Assert.assertArrayEquals((Object[])exp, (Object[])res);
    }
}

