/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system;

import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.UploadDetails;
import org.apache.jena.fuseki.system.UploadDetailsWithName;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;

public class Upload {
    public static UploadDetails incomingData(HttpAction action, StreamRDF dest) {
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null) {
            ServletOps.errorBadRequest("No content type");
            return null;
        }
        if (WebContent.matchContentType(WebContent.ctMultipartFormData, ct)) {
            return Upload.fileUploadWorker(action, dest);
        }
        String base = ActionLib.wholeRequestURL(action.request);
        Lang lang = RDFLanguages.contentTypeToLang(ct.getContentTypeStr());
        if (lang == null) {
            ServletOps.errorBadRequest("Unknown content type for triples: " + ct);
            return null;
        }
        long len = action.request.getContentLengthLong();
        StreamRDFCounting countingDest = StreamRDFLib.count(dest);
        try {
            ActionLib.parse(action, countingDest, lang, base);
            UploadDetails details = new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
            action.log.info(String.format("[%d] Body: Content-Length=%d, Content-Type=%s, Charset=%s => %s : %s", action.id, len, ct.getContentTypeStr(), ct.getCharset(), lang.getName(), details.detailsStr()));
            return details;
        }
        catch (RiotParseException ex) {
            action.log.info(String.format("[%d] Attempt to load: Content-Length=%d, Content-Type=%s, Charset=%s => %s", action.id, len, ct.getContentTypeStr(), ct.getCharset(), ex.getMessage()));
            ActionLib.consumeBody(action);
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UploadDetails fileUploadWorker(HttpAction action, StreamRDF dest) {
        String base = ActionLib.wholeRequestURL(action.request);
        ServletFileUpload upload = new ServletFileUpload();
        StreamRDFCounting countingDest = StreamRDFLib.count(dest);
        try {
            FileItemIterator iter = upload.getItemIterator(action.request);
            while (iter.hasNext()) {
                String printfilename;
                FileItemStream fileStream = iter.next();
                if (fileStream.isFormField()) {
                    String fieldName = fileStream.getFieldName();
                    InputStream stream = fileStream.openStream();
                    String value = Streams.asString(stream, "UTF-8");
                    ServletOps.errorBadRequest(String.format("Only files accepted in multipart file upload (got %s=%s)", fieldName, value));
                    return null;
                }
                InputStream input = fileStream.openStream();
                String contentTypeHeader = fileStream.getContentType();
                ContentType ct = ContentType.create(contentTypeHeader);
                Lang lang = null;
                if (!WebContent.matchContentType(WebContent.ctTextPlain, ct)) {
                    lang = RDFLanguages.contentTypeToLang(ct.getContentTypeStr());
                }
                if (lang == null) {
                    String name = fileStream.getName();
                    if (name == null || name.equals("")) {
                        ServletOps.errorBadRequest("No name for content - can't determine RDF syntax");
                    }
                    lang = RDFLanguages.pathnameToLang(name);
                    if (name.endsWith(".gz")) {
                        input = new GZIPInputStream(input);
                    }
                }
                if (lang == null) {
                    lang = RDFLanguages.RDFXML;
                }
                if ((printfilename = fileStream.getName()) == null || printfilename.equals("")) {
                    printfilename = "<none>";
                }
                StreamRDFCounting countingDest2 = StreamRDFLib.count(countingDest);
                try {
                    ActionLib.parse(action, countingDest2, input, lang, base);
                    UploadDetails details1 = new UploadDetails(countingDest2.count(), countingDest2.countTriples(), countingDest2.countQuads());
                    action.log.info(String.format("[%d] Filename: %s, Content-Type=%s, Charset=%s => %s : %s", action.id, printfilename, ct.getContentTypeStr(), ct.getCharset(), lang.getName(), details1.detailsStr()));
                }
                catch (RiotParseException ex) {
                    action.log.info(String.format("[%d] Filename: %s, Content-Type=%s, Charset=%s => %s : %s", action.id, printfilename, ct.getContentTypeStr(), ct.getCharset(), lang.getName(), ex.getMessage()));
                    ActionLib.consumeBody(action);
                    throw ex;
                }
            }
            return new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ServletOps.errorOccurred(ex.getMessage());
        }
        return new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
    }

    public static UploadDetailsWithName multipartUploadWorker(HttpAction action, String base) {
        DatasetGraph dsgTmp = DatasetGraphFactory.create();
        ServletFileUpload upload = new ServletFileUpload();
        String graphName = null;
        boolean isQuads = false;
        long count = -1L;
        String name = null;
        ContentType ct = null;
        Lang lang = null;
        try {
            FileItemIterator iter = upload.getItemIterator(action.request);
            while (iter.hasNext()) {
                String contentTypeHeader;
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                InputStream input = item.openStream();
                if (item.isFormField()) {
                    String value = Streams.asString(input, "UTF-8");
                    if (fieldName.equals("graph")) {
                        graphName = value;
                        if (graphName == null || graphName.equals("") || graphName.equals("default")) continue;
                        try {
                            IRIx iri2 = IRIx.create(value);
                            if (iri2.isReference()) continue;
                            ServletOps.errorBadRequest("IRI not suitable: " + graphName);
                        }
                        catch (IRIException ex) {
                            ServletOps.errorBadRequest("Bad IRI: " + graphName);
                        }
                        continue;
                    }
                    if (fieldName.equals("default-graph-uri")) {
                        graphName = null;
                        continue;
                    }
                    action.log.info(String.format("[%d] Upload: Field=%s ignored", action.id, fieldName));
                    continue;
                }
                name = item.getName();
                if (name == null || name.equals("") || name.equals("UNSET FILE NAME")) {
                    ServletOps.errorBadRequest("No name for content - can't determine RDF syntax");
                }
                if ((lang = RDFLanguages.contentTypeToLang((ct = ContentType.create(contentTypeHeader = item.getContentType())).getContentTypeStr())) == null) {
                    lang = RDFLanguages.pathnameToLang(name);
                    if (name.endsWith(".gz")) {
                        input = new GZIPInputStream(input);
                    }
                }
                if (lang == null) {
                    lang = RDFLanguages.RDFXML;
                }
                isQuads = RDFLanguages.isQuads(lang);
                action.log.info(String.format("[%d] Upload: Filename: %s, Content-Type=%s, Charset=%s => %s", action.id, name, ct.getContentTypeStr(), ct.getCharset(), lang.getName()));
                StreamRDF x = StreamRDFLib.dataset(dsgTmp);
                StreamRDFCounting dest = StreamRDFLib.count(x);
                try {
                    ActionLib.parse(action, dest, input, lang, base);
                }
                catch (RiotParseException ex) {
                    IO.skipToEnd(input);
                    ServletOps.errorParseError(ex);
                }
                count = dest.count();
            }
            if (graphName == null || graphName.equals("")) {
                graphName = "default";
            }
            if (isQuads) {
                graphName = null;
            }
            return new UploadDetailsWithName(graphName, dsgTmp, count);
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ServletOps.errorOccurred(ex);
            return null;
        }
    }
}

