/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionExecLib;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ResponseDataset;
import org.apache.jena.fuseki.servlets.ResponseJson;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.SPARQLProtocol;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.engine.EngineLib;
import org.apache.jena.sparql.resultset.SPARQLResult;

public abstract class SPARQLQueryProcessor
extends ActionService {
    private static final String QueryParseBase = "http://server/unset-base/";
    private volatile Set<String> acceptedParams_ = null;
    private static Collection<String> customParams_ = Collections.emptyList();
    private static Collection<String> stdParams_ = Arrays.asList("query", "default-graph-uri", "named-graph-uri");
    private static Collection<String> fusekiParams_ = Arrays.asList("query-ref", "stylesheet", "accept", "output", "format", "results", "callback", "force-accept", "timeout");

    @Override
    public void execOptions(HttpAction action) {
        ServletBase.setCommonHeadersForOptions(action.response);
        ActionLib.doOptionsGetPost(action);
        ServletOps.success(action);
    }

    @Override
    public void execHead(HttpAction action) {
        super.execHead(action);
    }

    @Override
    public void execGet(HttpAction action) {
        this.executeLifecycle(action);
    }

    @Override
    public void execPost(HttpAction action) {
        this.executeLifecycle(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> acceptedParams(HttpAction action) {
        if (this.acceptedParams_ == null) {
            SPARQLQueryProcessor sPARQLQueryProcessor = this;
            synchronized (sPARQLQueryProcessor) {
                if (this.acceptedParams_ == null) {
                    this.acceptedParams_ = this.generateAcceptedParams();
                }
            }
        }
        return this.acceptedParams_;
    }

    @Override
    public void validate(HttpAction action) {
        String method = action.request.getMethod().toUpperCase(Locale.ROOT);
        if ("OPTIONS".equals(method)) {
            return;
        }
        if (!"POST".equals(method) && !"GET".equals(method)) {
            ServletOps.errorMethodNotAllowed("Not a GET or POST request");
        }
        if ("GET".equals(method) && action.request.getQueryString() == null) {
            ServletOps.warning(action, "Service Description / SPARQL Query / " + action.request.getRequestURI());
            ServletOps.errorNotFound("Service Description: " + action.request.getRequestURI());
        }
        Collection<String> x = this.acceptedParams(action);
        this.validateParams(action, x);
        this.validateRequest(action);
    }

    protected abstract void validateRequest(HttpAction var1);

    protected void validateParams(HttpAction action, Collection<String> params) {
        HttpServletRequest request = action.request;
        ContentType ct = FusekiNetLib.getContentType(request);
        boolean mustHaveQueryParam = true;
        if (ct != null) {
            String incoming = ct.getContentTypeStr();
            if (WebContent.matchContentType(WebContent.ctSPARQLQuery, ct)) {
                mustHaveQueryParam = false;
            } else if (!WebContent.matchContentType(WebContent.ctHTMLForm, ct)) {
                ServletOps.error(415, "Unsupported: " + incoming);
            }
        }
        if (mustHaveQueryParam) {
            String queryStr;
            int N = SPARQLProtocol.countParamOccurences(request, "query");
            if (N == 0) {
                ServletOps.errorBadRequest("SPARQL Query: No 'query=' parameter");
            }
            if (N > 1) {
                ServletOps.errorBadRequest("SPARQL Query: Multiple 'query=' parameters");
            }
            if ((queryStr = request.getParameter("query")) == null) {
                ServletOps.errorBadRequest("SPARQL Query: No query specified (no 'query=' found)");
            }
            if (queryStr.isEmpty()) {
                ServletOps.errorBadRequest("SPARQL Query: Empty query string");
            }
        }
        if (params != null) {
            Enumeration<String> en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = en.nextElement();
                if (params.contains(name)) continue;
                ServletOps.warning(action, "SPARQL Query: Unrecognize request parameter (ignored): " + name);
            }
        }
    }

    @Override
    public final void execute(HttpAction action) {
        if (action.request.getMethod().equals("GET")) {
            this.executeWithParameter(action);
            return;
        }
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null || WebContent.isHtmlForm(ct)) {
            this.executeWithParameter(action);
            return;
        }
        if (WebContent.matchContentType(ct, WebContent.ctSPARQLQuery)) {
            this.executeBody(action);
            return;
        }
        ServletOps.error(415, "Bad content type: " + ct.getContentTypeStr());
    }

    protected void executeWithParameter(HttpAction action) {
        String queryString = action.request.getParameter("query");
        this.execute(queryString, action);
    }

    protected void executeBody(HttpAction action) {
        String queryString = null;
        try {
            ServletInputStream input = action.request.getInputStream();
            queryString = IO.readWholeFileAsUTF8(input);
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
        this.execute(queryString, action);
    }

    protected void execute(String queryString, HttpAction action) {
        String msg;
        String queryStringLog = ServletOps.formatForLog(queryString);
        if (action.verbose) {
            String str2 = queryString;
            if (str2.endsWith("\n")) {
                str2 = str2.substring(0, str2.length() - 1);
            }
            action.log.info(String.format("[%d] Query = \n%s", action.id, str2));
        } else {
            action.log.info(String.format("[%d] Query = %s", action.id, queryStringLog));
        }
        Query query2 = null;
        try {
            query2 = QueryFactory.create(queryString, QueryParseBase, Syntax.syntaxARQ);
            queryStringLog = this.formatForLog(query2);
            this.validateQuery(action, query2);
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (QueryParseException ex) {
            msg = SPARQLProtocol.messageForParseException(ex);
            action.log.warn(String.format("[%d] %s", action.id, msg));
            ServletOps.errorBadRequest(msg);
        }
        catch (QueryException ex) {
            msg = SPARQLProtocol.messageForException(ex);
            action.log.warn(String.format("[%d] %s", action.id, msg));
            ServletOps.errorBadRequest("Error: \n" + queryString + "\n" + msg);
        }
        try {
            action.beginRead();
            Pair<DatasetGraph, Query> p = this.decideDataset(action, query2, queryStringLog);
            DatasetGraph dataset = p.getLeft();
            Query q = p.getRight();
            if (q == null) {
                q = query2;
            }
            try (QueryExecution qExec = this.createQueryExecution(action, q, dataset);){
                SPARQLResult result = this.executeQuery(action, qExec, query2, queryStringLog);
                this.sendResults(action, result, query2.getPrologue());
            }
        }
        catch (QueryParseException ex) {
            ServletOps.errorBadRequest("Query parse error: \n" + queryString + "\n" + SPARQLProtocol.messageForException(ex));
        }
        catch (QueryCancelledException ex) {
            ActionExecLib.incCounter(action.getEndpoint().getCounters(), CounterName.QueryTimeouts);
            throw ex;
        }
        finally {
            action.endRead();
        }
    }

    protected abstract void validateQuery(HttpAction var1, Query var2);

    protected QueryExecution createQueryExecution(HttpAction action, Query query2, DatasetGraph dataset) {
        return QueryExecution.create().query(query2).dataset(dataset).context(action.getContext()).build();
    }

    protected SPARQLResult executeQuery(HttpAction action, QueryExecution queryExecution, Query requestQuery, String queryStringLog) {
        this.setAnyProtocolTimeouts(queryExecution, action);
        if (requestQuery.isSelectType()) {
            ResultSet rs = queryExecution.execSelect();
            rs.hasNext();
            return new SPARQLResult(rs);
        }
        if (requestQuery.isConstructType()) {
            Dataset dataset = queryExecution.execConstructDataset();
            return new SPARQLResult(dataset);
        }
        if (requestQuery.isDescribeType()) {
            Model model = queryExecution.execDescribe();
            return new SPARQLResult(model);
        }
        if (requestQuery.isAskType()) {
            boolean b = queryExecution.execAsk();
            return new SPARQLResult(b);
        }
        if (requestQuery.isJsonType()) {
            Iterator<JsonObject> jsonIterator = queryExecution.execJsonItems();
            action.log.info(String.format("[%d] exec/json", action.id));
            return new SPARQLResult(jsonIterator);
        }
        ServletOps.errorBadRequest("Unknown query type - " + queryStringLog);
        return null;
    }

    private void setAnyProtocolTimeouts(QueryExecution qExec, HttpAction action) {
        String desiredTimeoutStr = null;
        String timeoutHeader = action.request.getHeader("Timeout");
        String timeoutParameter = action.request.getParameter("timeout");
        if (timeoutHeader != null) {
            desiredTimeoutStr = timeoutHeader;
        }
        if (timeoutParameter != null) {
            desiredTimeoutStr = timeoutParameter;
        }
        EngineLib.parseSetTimeout(qExec, desiredTimeoutStr, TimeUnit.SECONDS, true);
    }

    protected abstract Pair<DatasetGraph, Query> decideDataset(HttpAction var1, Query var2, String var3);

    protected void sendResults(HttpAction action, SPARQLResult result, Prologue qPrologue) {
        if (result.isResultSet()) {
            ResponseResultSet.doResponseResultSet(action, result.getResultSet(), qPrologue);
        } else if (result.isDataset()) {
            ResponseDataset.doResponseDataset(action, result.getDataset());
        } else if (result.isModel()) {
            ResponseDataset.doResponseModel(action, result.getModel());
        } else if (result.isBoolean()) {
            ResponseResultSet.doResponseResultSet(action, result.getBooleanResult());
        } else if (result.isJson()) {
            ResponseJson.doResponseJson(action, result.getJsonItems());
        } else {
            ServletOps.errorOccurred("Unknown or invalid result type");
        }
    }

    private String formatForLog(Query query2) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.setFlatMode(true);
        query2.serialize(out);
        return out.asString();
    }

    private String getRemoteString(String queryURI) {
        return HttpOp.execHttpGetString(queryURI);
    }

    protected Set<String> generateAcceptedParams() {
        HashSet<String> x = new HashSet<String>();
        x.addAll(this.stdParams());
        x.addAll(this.fusekiParams());
        x.addAll(this.customParams());
        return x;
    }

    protected Collection<String> customParams() {
        return customParams_;
    }

    protected Collection<String> stdParams() {
        return stdParams_;
    }

    protected Collection<String> fusekiParams() {
        return fusekiParams_;
    }
}

