/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.fuseki.servlets.ActionREST;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQLProtocol;
import org.apache.jena.fuseki.servlets.ServletOps;

public abstract class GSP_Base
extends ActionREST {
    protected GSP_Base() {
    }

    @Override
    public void validate(HttpAction action) {
        if (GSP_Base.isQuads(action)) {
            GSP_Base.validateQuads(action);
        } else {
            GSP_Base.validateGSP(action);
        }
    }

    protected static boolean isQuads(HttpAction action) {
        return action.request.getQueryString() == null;
    }

    private static void validateQuads(HttpAction action) {
    }

    private static void validateGSP(HttpAction action) {
        HttpServletRequest request = action.request;
        if (request.getQueryString() == null) {
            ServletOps.errorBadRequest("No query string. ?default or ?graph required.");
        }
        String g = request.getParameter("graph");
        String d = request.getParameter("default");
        if (g != null && d != null) {
            ServletOps.errorBadRequest("Both ?default and ?graph in the query string of the request");
        }
        if (g == null && d == null) {
            ServletOps.errorBadRequest("Neither ?default nor ?graph in the query string of the request");
        }
        int x1 = SPARQLProtocol.countParamOccurences(request, "graph");
        int x2 = SPARQLProtocol.countParamOccurences(request, "default");
        if (x1 > 1) {
            ServletOps.errorBadRequest("Multiple ?default in the query string of the request");
        }
        if (x2 > 1) {
            ServletOps.errorBadRequest("Multiple ?graph in the query string of the request");
        }
        Enumeration<String> en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String h = en.nextElement();
            if (!"graph".equals(h) && !"default".equals(h)) {
                ServletOps.errorBadRequest("Unknown parameter '" + h + "'");
            }
            if (request.getParameterValues(h).length == 1) continue;
            ServletOps.errorBadRequest("Multiple parameters '" + h + "'");
        }
    }
}

