/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.ctl;

import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.ctl.ActionCtl;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public abstract class ActionContainerItem
extends ActionCtl {
    protected ActionContainerItem() {
    }

    @Override
    public final void execute(HttpAction action) {
        String method = action.request.getMethod();
        if (method.equals("GET")) {
            this.performGet(action);
        } else if (method.equals("POST")) {
            this.performPost(action);
        } else if (method.equals("DELETE")) {
            this.performDelete(action);
        } else {
            ServletOps.error(405);
        }
    }

    @Override
    public void execOptions(HttpAction action) {
        ActionLib.doOptionsGetPostDeleteHead(action);
        ServletOps.success(action);
    }

    protected final boolean isContainerAction(HttpAction action) {
        return ActionContainerItem.getItemName(action) == null;
    }

    protected void performGet(HttpAction action) {
        JsonValue v = this.isContainerAction(action) ? this.execGetContainer(action) : this.execGetItem(action);
        ServletOps.sendJsonReponse(action, v);
    }

    protected abstract JsonValue execGetContainer(HttpAction var1);

    protected abstract JsonValue execGetItem(HttpAction var1);

    protected void performPost(HttpAction action) {
        JsonValue v = this.isContainerAction(action) ? this.execPostContainer(action) : this.execPostItem(action);
        ServletOps.sendJsonReponse(action, v);
    }

    protected abstract JsonValue execPostContainer(HttpAction var1);

    protected abstract JsonValue execPostItem(HttpAction var1);

    protected void performDelete(HttpAction action) {
        if (this.isContainerAction(action)) {
            this.execDeleteContainer(action);
        } else {
            this.execDeleteItem(action);
        }
        ServletOps.success(action);
    }

    protected void execDeleteContainer(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE", "DELETE applied to a container");
    }

    protected void execDeleteItem(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE");
    }
}

