/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;

public final class ComponentGroup {
    private Map<ComponentId, TransactionalComponent> group = new HashMap<ComponentId, TransactionalComponent>();

    public ComponentGroup(TransactionalComponent ... components) {
        Arrays.asList(components).forEach(this::add);
    }

    private ComponentGroup(Map<ComponentId, TransactionalComponent> group) {
        this.group.putAll(group);
    }

    public void addAll(Collection<TransactionalComponent> components) {
        components.forEach(this::add);
    }

    public void add(TransactionalComponent component) {
        Objects.requireNonNull(component);
        if (component.getComponentId() == null) {
            Log.warn(this, "Null component id - likely to be overwritten: " + component);
        }
        if (this.group.containsKey(component.getComponentId())) {
            Log.warn(this, component.getComponentId().toString());
            Log.warn(this, "Add component already in the group: " + component);
        }
        this.group.put(component.getComponentId(), component);
    }

    void remove(ComponentId componentId) {
        this.group.remove(componentId);
    }

    public TransactionalComponent findComponent(ComponentId componentId) {
        return this.group.get(componentId);
    }

    public void forEachComponent(Consumer<? super TransactionalComponent> action) {
        this.group.values().forEach(action);
    }

    public void forEach(BiConsumer<ComponentId, TransactionalComponent> action) {
        this.group.forEach(action);
    }

    public void addAll(ComponentGroup components) {
        this.group.putAll(components.group);
    }

    public int size() {
        return this.group.size();
    }
}

