/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.prefixes;

import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixMap;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.PrefixEntry;
import org.apache.jena.sparql.core.Quad;

public class StoragePrefixesView
implements StoragePrefixMap {
    private final StoragePrefixes dsgPrefixes;
    private final Node graphName;
    private static final Node dftGraph = Quad.defaultGraphIRI;
    private static final Node dftGraph2 = Quad.defaultGraphNodeGenerated;

    public static StoragePrefixMap viewDataset(StoragePrefixes dsgPrefixes) {
        return new StoragePrefixesView(dsgPrefixes, Quad.defaultGraphNodeGenerated);
    }

    static StoragePrefixMap viewDefaultGraph(StoragePrefixes dsgPrefixes) {
        return new StoragePrefixesView(dsgPrefixes, Quad.defaultGraphNodeGenerated);
    }

    static StoragePrefixMap viewGraph(StoragePrefixes dsgPrefixes, Node graphName) {
        return new StoragePrefixesView(dsgPrefixes, graphName);
    }

    private StoragePrefixesView(StoragePrefixes dsgPrefixes, Node graphName) {
        this.dsgPrefixes = dsgPrefixes;
        this.graphName = graphName;
    }

    @Override
    public void put(String prefix, String uriStr) {
        this.dsgPrefixes.add(this.graphName, prefix, uriStr);
    }

    @Override
    public String get(String prefix) {
        return this.dsgPrefixes.get(this.graphName, prefix);
    }

    @Override
    public boolean containsPrefix(String prefix) {
        return this.get(prefix) != null;
    }

    @Override
    public void remove(String prefix) {
        this.dsgPrefixes.delete(this.graphName, prefix);
    }

    @Override
    public void clear() {
        List<PrefixEntry> x = Iter.toList(this.iterator());
        for (PrefixEntry e2 : x) {
            this.remove(e2.getPrefix());
        }
    }

    @Override
    public boolean isEmpty() {
        return !this.dsgPrefixes.listGraphNodes().hasNext();
    }

    @Override
    public int size() {
        return (int)Iter.count(this.dsgPrefixes.get(this.graphName));
    }

    @Override
    public Iterator<PrefixEntry> iterator() {
        return this.dsgPrefixes.get(this.graphName);
    }

    @Override
    public Stream<PrefixEntry> stream() {
        return Iter.asStream(this.dsgPrefixes.get(this.graphName));
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        this.stream().map(e2 -> "(" + e2.getPrefix() + "=" + e2.getUri() + ")").forEach(sj::add);
        return sj.toString();
    }
}

