/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonParseException;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.LibJsonTest;
import org.junit.Test;

public class TestJson {
    @Test
    public void js_value_1() {
        LibJsonTest.read("\"abc\"", new JsonString("abc"));
    }

    @Test
    public void js_value_2() {
        LibJsonTest.read("123", JsonNumber.value(123L));
    }

    @Test
    public void js_value_3() {
        LibJsonTest.read("true", new JsonBoolean(true));
    }

    @Test
    public void js_value_4() {
        LibJsonTest.read("{}", new JsonObject());
    }

    @Test
    public void js_value_5() {
        JsonObject obj = new JsonObject();
        obj.put("a", JsonNumber.value(123L));
        LibJsonTest.read("{ \"a\": 123 }", obj);
    }

    @Test
    public void js_value_6() {
        JsonArray array = new JsonArray();
        LibJsonTest.read("[ ]", array);
    }

    @Test
    public void js_value_7() {
        JsonArray array = new JsonArray();
        array.add(JsonNumber.value(123L));
        LibJsonTest.read("[ 123 ]", array);
    }

    @Test
    public void js_value_8() {
        JsonObject obj = new JsonObject();
        JsonArray array = new JsonArray();
        array.add(JsonNumber.value(123L));
        obj.put("a", array);
        LibJsonTest.read("{ \"a\" : [ 123 ] }", obj);
    }

    @Test(expected=JsonParseException.class)
    public void js_value_9() {
        JSON.parse("[1 2 3]");
    }

    @Test(expected=JsonParseException.class)
    public void js_value_10() {
        JSON.parse("1");
    }

    @Test(expected=JsonParseException.class)
    public void js_value_11() {
        JSON.parse("\"foo\"");
    }

    @Test
    public void js_value_12() {
        JSON.parse("{}");
    }

    @Test
    public void js_value_13() {
        LibJsonTest.read("\"abc\\bd\"", new JsonString("abc\bd"));
    }
}

