/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.jena.atlas.data.SortedDataBag;
import org.apache.jena.atlas.data.ThresholdPolicyCount;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.system.SerializationFactoryFinder;
import org.junit.Assert;
import org.junit.Test;

public class TestSortedDataBag {
    private static final String LETTERS = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
    private Random random;

    @Test
    public void testSorting() {
        this.testSorting(500, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSorting(int numBindings, int threshold) {
        List<Binding> unsorted = this.randomBindings(numBindings);
        ArrayList<SortCondition> conditions = new ArrayList<SortCondition>();
        conditions.add(new SortCondition(new ExprVar("8"), 1));
        conditions.add(new SortCondition(new ExprVar("1"), 1));
        conditions.add(new SortCondition(new ExprVar("0"), -1));
        BindingComparator comparator = new BindingComparator(conditions);
        ArrayList<Binding> sorted = new ArrayList<Binding>();
        try (SortedDataBag<Binding> db = new SortedDataBag<Binding>(new ThresholdPolicyCount(threshold), SerializationFactoryFinder.bindingSerializationFactory(), comparator);){
            db.addAll(unsorted);
            Iterator<Binding> iter = db.iterator();
            while (iter.hasNext()) {
                sorted.add(iter.next());
            }
            Iter.close(iter);
        }
        Collections.sort(unsorted, comparator);
        Assert.assertEquals(unsorted, sorted);
    }

    @Test
    public void testSortingWithPreMerge() {
        int origMaxSpillFiles = SortedDataBag.MAX_SPILL_FILES;
        try {
            SortedDataBag.MAX_SPILL_FILES = 2;
            this.testSorting(1, 1);
            SortedDataBag.MAX_SPILL_FILES = 2;
            this.testSorting(2, 1);
            SortedDataBag.MAX_SPILL_FILES = 2;
            this.testSorting(3, 1);
            SortedDataBag.MAX_SPILL_FILES = 2;
            this.testSorting(4, 1);
            SortedDataBag.MAX_SPILL_FILES = 2;
            this.testSorting(5, 1);
            SortedDataBag.MAX_SPILL_FILES = 2;
            this.testSorting(1, 10);
            SortedDataBag.MAX_SPILL_FILES = 2;
            this.testSorting(1000, 10);
            SortedDataBag.MAX_SPILL_FILES = 100;
            this.testSorting(1000, 10);
            SortedDataBag.MAX_SPILL_FILES = 2;
            this.testSorting(10, 10);
            SortedDataBag.MAX_SPILL_FILES = 5;
            this.testSorting(10, 10);
        }
        finally {
            SortedDataBag.MAX_SPILL_FILES = origMaxSpillFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryFilesAreCleanedUpAfterCompletion() {
        int count;
        List<Binding> unsorted = this.randomBindings(500);
        ArrayList<SortCondition> conditions = new ArrayList<SortCondition>();
        conditions.add(new SortCondition(new ExprVar("8"), 1));
        BindingComparator comparator = new BindingComparator(conditions);
        ArrayList<File> spillFiles = new ArrayList<File>();
        try (SortedDataBag<Binding> db = new SortedDataBag<Binding>(new ThresholdPolicyCount(10L), SerializationFactoryFinder.bindingSerializationFactory(), comparator);){
            db.addAll(unsorted);
            spillFiles.addAll(db.getSpillFiles());
            count = 0;
            for (File file : spillFiles) {
                if (!file.exists()) continue;
                ++count;
            }
            Assert.assertEquals((long)49L, (long)count);
            Iterator<Binding> iter = db.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            Iter.close(iter);
        }
        count = 0;
        for (File file : spillFiles) {
            if (!file.exists()) continue;
            ++count;
        }
        Assert.assertEquals((long)0L, (long)count);
    }

    private List<Binding> randomBindings(int numBindings) {
        this.random = new Random();
        Var[] vars = new Var[]{Var.alloc("1"), Var.alloc("2"), Var.alloc("3"), Var.alloc("4"), Var.alloc("5"), Var.alloc("6"), Var.alloc("7"), Var.alloc("8"), Var.alloc("9"), Var.alloc("0")};
        ArrayList<Binding> toReturn = new ArrayList<Binding>();
        for (int i = 0; i < numBindings; ++i) {
            toReturn.add(this.randomBinding(vars));
        }
        return toReturn;
    }

    private Binding randomBinding(Var[] vars) {
        BindingBuilder builder = Binding.builder();
        builder.add(vars[0], NodeFactory.createBlankNode());
        builder.add(vars[1], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[2], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[3], NodeFactory.createLiteral(this.randomString(20)));
        builder.add(vars[4], NodeFactory.createBlankNode());
        builder.add(vars[5], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[6], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[7], NodeFactory.createLiteral(this.randomString(5)));
        builder.add(vars[8], NodeFactory.createLiteral("" + this.random.nextInt(), XSDDatatype.XSDinteger));
        builder.add(vars[9], NodeFactory.createBlankNode());
        return builder.build();
    }

    private String randomURI() {
        return String.format("http://%s.example.com/%s", this.randomString(10), this.randomString(10));
    }

    private String randomString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(LETTERS.charAt(this.random.nextInt(LETTERS.length())));
        }
        return builder.toString();
    }

    private void getNextAndExpectException(QueryIterator iter) {
        try {
            iter.hasNext();
            Assert.fail((String)"Expected an exception here");
        }
        catch (QueryCancelledException queryCancelledException) {
        }
        catch (Exception e2) {
            Assert.fail((String)"Unexpected exception");
        }
    }
}

