/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.jena.atlas.data.DistinctDataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyCount;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderBinding;
import org.apache.jena.sparql.system.SerializationFactoryFinder;
import org.apache.jena.sparql.util.NodeUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestDistinctDataBag {
    private static final String LETTERS = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
    Random random = new Random();
    static Binding b12 = TestDistinctDataBag.build("(?a 1) (?b 2)");
    static Binding b19 = TestDistinctDataBag.build("(?a 1) (?b 9)");
    static Binding b02 = TestDistinctDataBag.build("(?b 2)");
    static Binding b10 = TestDistinctDataBag.build("(?a 1)");
    static Binding b0 = TestDistinctDataBag.build("");
    static Binding bb1 = TestDistinctDataBag.build("(?a _:XYZ) (?b 1)");
    static Binding x10 = TestDistinctDataBag.build("(?x <http://example/abc>)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinct() {
        ArrayList<Binding> undistinct = new ArrayList<Binding>();
        undistinct.add(b12);
        undistinct.add(b19);
        undistinct.add(b02);
        undistinct.add(b12);
        undistinct.add(b19);
        undistinct.add(b12);
        undistinct.add(b02);
        undistinct.add(x10);
        List<Binding> control = Iter.toList(Iter.distinct(undistinct.iterator()));
        ArrayList<Binding> distinct = new ArrayList<Binding>();
        try (DistinctDataBag<Binding> db = new DistinctDataBag<Binding>((ThresholdPolicy<Binding>)new ThresholdPolicyCount(2L), SerializationFactoryFinder.bindingSerializationFactory(), (Comparator<Binding>)new BindingComparator(new ArrayList<SortCondition>()));){
            db.addAll(undistinct);
            Iterator<Binding> iter = db.iterator();
            while (iter.hasNext()) {
                distinct.add(iter.next());
            }
            Iter.close(iter);
        }
        Assert.assertEquals((long)control.size(), (long)distinct.size());
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTest(control, distinct, NodeUtils.sameNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryFilesAreCleanedUpAfterCompletion() {
        int count;
        ArrayList<Binding> undistinct = new ArrayList<Binding>();
        this.random = new Random();
        Var[] vars = new Var[]{Var.alloc("1"), Var.alloc("2"), Var.alloc("3"), Var.alloc("4"), Var.alloc("5"), Var.alloc("6"), Var.alloc("7"), Var.alloc("8"), Var.alloc("9"), Var.alloc("0")};
        for (int i = 0; i < 500; ++i) {
            undistinct.add(this.randomBinding(vars));
        }
        ArrayList<File> spillFiles = new ArrayList<File>();
        try (DistinctDataBag<Binding> db = new DistinctDataBag<Binding>((ThresholdPolicy<Binding>)new ThresholdPolicyCount(10L), SerializationFactoryFinder.bindingSerializationFactory(), (Comparator<Binding>)new BindingComparator(new ArrayList<SortCondition>()));){
            db.addAll(undistinct);
            spillFiles.addAll(db.getSpillFiles());
            count = 0;
            for (File file : spillFiles) {
                if (!file.exists()) continue;
                ++count;
            }
            Assert.assertEquals((long)49L, (long)count);
            Iterator<Binding> iter = db.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            Iter.close(iter);
        }
        count = 0;
        for (File file : spillFiles) {
            if (!file.exists()) continue;
            ++count;
        }
        Assert.assertEquals((long)0L, (long)count);
    }

    private static Binding build(String string) {
        Item item = SSE.parse("(binding " + string + ")");
        return BuilderBinding.build(item);
    }

    private Binding randomBinding(Var[] vars) {
        BindingBuilder builder = Binding.builder();
        builder.add(vars[0], NodeFactory.createBlankNode());
        builder.add(vars[1], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[2], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[3], NodeFactory.createLiteral(this.randomString(20)));
        builder.add(vars[4], NodeFactory.createBlankNode());
        builder.add(vars[5], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[6], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[7], NodeFactory.createLiteral(this.randomString(5)));
        builder.add(vars[8], NodeFactory.createLiteral("" + this.random.nextInt(), XSDDatatype.XSDinteger));
        builder.add(vars[9], NodeFactory.createBlankNode());
        return builder.build();
    }

    public String randomURI() {
        return String.format("http://%s.example.com/%s", this.randomString(10), this.randomString(10));
    }

    public String randomString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(LETTERS.charAt(this.random.nextInt(LETTERS.length())));
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptionalVariables() {
        Binding binding1 = BindingFactory.binding(Var.alloc("1"), NodeFactory.createLiteral("A"));
        Binding binding2 = BindingFactory.binding(Var.alloc("1"), NodeFactory.createLiteral("A"), Var.alloc("2"), NodeFactory.createLiteral("B"));
        List<Binding> undistinct = Arrays.asList(binding1, binding2, binding1);
        List<Binding> control = Iter.toList(Iter.distinct(undistinct.iterator()));
        ArrayList<Binding> distinct = new ArrayList<Binding>();
        try (DistinctDataBag<Binding> db = new DistinctDataBag<Binding>((ThresholdPolicy<Binding>)new ThresholdPolicyCount(2L), SerializationFactoryFinder.bindingSerializationFactory(), (Comparator<Binding>)new BindingComparator(new ArrayList<SortCondition>()));){
            db.addAll(undistinct);
            Iterator<Binding> iter = db.iterator();
            while (iter.hasNext()) {
                distinct.add(iter.next());
            }
            Iter.close(iter);
        }
        Assert.assertEquals((long)control.size(), (long)distinct.size());
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTest(control, distinct, NodeUtils.sameNode));
    }
}

