/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.sparql.tests;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.arq.junit.sparql.tests.SparqlTestLib;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.vocabulary.TestManifestUpdate_11;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.vocabulary.RDFS;
import org.junit.Assert;

public class UpdateExecTest
implements Runnable {
    private final ManifestEntry testEntry;
    private final Creator<Dataset> creator;

    public UpdateExecTest(ManifestEntry entry) {
        this(entry, () -> DatasetFactory.create());
    }

    public UpdateExecTest(ManifestEntry entry, Creator<Dataset> maker) {
        this.testEntry = entry;
        this.creator = maker;
    }

    @Override
    public void run() {
        Dataset input = UpdateExecTest.getDataset(this.creator.create(), this.testEntry.getAction());
        Dataset output = UpdateExecTest.getDataset(DatasetFactory.create(), this.testEntry.getResult());
        String updateFile = this.testEntry.getAction().getProperty(TestManifestUpdate_11.request).getResource().getURI();
        UpdateRequest request = UpdateFactory.read(updateFile, Syntax.syntaxARQ);
        UpdateAction.execute(request, input);
        boolean b = UpdateExecTest.datasetSame(input, output, false);
        if (!b) {
            System.out.println("---- " + this.testEntry.getName());
            System.out.println("---- Got: ");
            System.out.println(input.asDatasetGraph());
            System.out.println("---- Expected");
            System.out.println(output.asDatasetGraph());
            UpdateExecTest.datasetSame(input, output, true);
            System.out.println("----------------------------------------");
        }
        Assert.assertTrue((String)"Datasets are different", (boolean)b);
    }

    private static boolean datasetSame(Dataset ds1, Dataset ds2, boolean verbose) {
        List<String> names2;
        List<String> names1 = Iter.toList(ds1.listNames());
        if (!names1.equals(names2 = Iter.toList(ds2.listNames()))) {
            if (verbose) {
                System.out.println("Different named graphs");
                System.out.println("  " + names1);
                System.out.println("  " + names2);
            }
            return false;
        }
        if (!ds1.getDefaultModel().isIsomorphicWith(ds2.getDefaultModel())) {
            if (verbose) {
                System.out.println("Default graphs differ");
            }
            return false;
        }
        for (String gn : names1) {
            Model m2;
            Model m1 = ds1.getNamedModel(gn);
            if (m1.isIsomorphicWith(m2 = ds2.getNamedModel(gn))) continue;
            if (verbose) {
                System.out.println("Different on named graph " + gn);
            }
            return false;
        }
        return true;
    }

    static Dataset getDataset(Dataset ds, Resource r) {
        List<String> dftData = UpdateExecTest.getAll(r, TestManifestUpdate_11.data);
        for (String x : dftData) {
            SparqlTestLib.parser(x).parse(ds);
        }
        StmtIterator cIter = r.listProperties(TestManifestUpdate_11.graphData);
        while (cIter.hasNext()) {
            Statement stmt = (Statement)cIter.next();
            Resource gn = stmt.getResource();
            if (gn.isAnon()) {
                if (!gn.hasProperty(TestManifestUpdate_11.graph)) {
                    System.err.println("No data for graphData");
                }
                String fn = gn.getProperty(TestManifestUpdate_11.graph).getResource().getURI();
                String name = gn.getProperty(RDFS.label).getString();
                Model m = ModelFactory.createDefaultModel();
                SparqlTestLib.parser(fn).parse(m);
                ds.addNamedModel(name, m);
                continue;
            }
            String x = gn.getURI();
            Model m = ModelFactory.createDefaultModel();
            SparqlTestLib.parser(x).parse(m);
            ds.addNamedModel(x, m);
        }
        cIter.close();
        return ds;
    }

    static List<String> getAll(Resource r, Property p) {
        ArrayList<String> l = new ArrayList<String>();
        StmtIterator cIter = r.listProperties(p);
        while (cIter.hasNext()) {
            Statement stmt = (Statement)cIter.next();
            String df = stmt.getObject().asResource().getURI();
            l.add(df);
        }
        cIter.close();
        return l;
    }
}

