/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.sparql.tests;

import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.arq.junit.sparql.tests.SparqlTestLib;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.sse.SSEParseException;
import org.apache.jena.sparql.util.QueryUtils;

public class SerializationTest
implements Runnable {
    static int count = 0;
    String queryString;
    ManifestEntry testEntry;

    public SerializationTest(ManifestEntry entry) {
        this.testEntry = entry;
    }

    @Override
    public void run() {
        Query query2 = SparqlTestLib.queryFromEntry(this.testEntry);
        this.runTestWorker(query2, query2.getSyntax());
    }

    protected void runTestWorker(Query query2, Syntax syntax) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        query2.serialize(buff, syntax);
        String baseURI = null;
        if (!query2.explicitlySetBaseURI()) {
            baseURI = query2.getBaseURI();
        }
        try {
            QueryUtils.checkParse(query2);
        }
        catch (RuntimeException ex) {
            System.err.println("**** Test: " + this.testEntry.getName());
            System.err.println("** " + ex.getMessage());
            System.err.println(query2);
            throw ex;
        }
        try {
            QueryUtils.checkOp(query2, true);
        }
        catch (SSEParseException ex) {
            System.err.println("**** Test: " + this.testEntry.getName());
            System.err.println("** Algebra error: " + ex.getMessage());
        }
    }
}

