/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.sparql.tests;

import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.arq.junit.sparql.tests.SparqlTestLib;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.Syntax;
import org.junit.Assert;

public class QuerySyntaxTest
implements Runnable {
    final boolean expectLegalSyntax;
    final Syntax testSyntax;
    final ManifestEntry testEntry;

    public QuerySyntaxTest(ManifestEntry entry, Syntax defSyntax, boolean positiveTest) {
        this.testEntry = entry;
        this.testSyntax = defSyntax;
        this.expectLegalSyntax = positiveTest;
    }

    @Override
    public void run() {
        try {
            Query query2 = SparqlTestLib.queryFromEntry(this.testEntry, this.testSyntax);
            if (!this.expectLegalSyntax) {
                Assert.fail((String)"Expected parse failure");
            }
        }
        catch (QueryException qEx) {
            if (this.expectLegalSyntax) {
                throw qEx;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Exception: " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }
}

