/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.runners;

import java.lang.annotation.Annotation;
import org.apache.jena.sparql.junit.EarlReport;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class RunnerOneTest
extends Runner {
    private static int count = 1;
    private final Description description;
    private final EarlReport report;
    private final Runnable testCase;
    private final String testURI;
    private final String name;

    public RunnerOneTest(String name, Runnable test) {
        this(name, test, null, null);
    }

    public RunnerOneTest(String name, Runnable test, String testURI, EarlReport report) {
        this.name = name;
        int count$ = count++;
        this.testCase = test;
        this.description = Description.createSuiteDescription((String)("T-" + count$ + ": " + name), (Annotation[])new Annotation[0]);
        this.testURI = testURI;
        this.report = report;
    }

    public Description getDescription() {
        return this.description;
    }

    public void run(RunNotifier notifier) {
        notifier.fireTestStarted(this.description);
        try {
            this.testCase.run();
            if (this.report != null) {
                this.report.success(this.testURI);
            }
        }
        catch (AssumptionViolatedException e2) {
            notifier.fireTestAssumptionFailed(new Failure(this.description, (Throwable)e2));
        }
        catch (Throwable ex) {
            if (this.report != null) {
                this.report.failure(this.testURI);
            }
            notifier.fireTestFailure(new Failure(this.description, ex));
        }
        finally {
            notifier.fireTestFinished(this.description);
        }
    }
}

