/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.runners;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.jena.arq.junit.manifest.Manifest;
import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.arq.junit.manifest.Manifests;
import org.apache.jena.arq.junit.manifest.Prefix;
import org.apache.jena.arq.junit.runners.Label;
import org.apache.jena.arq.junit.runners.RunnerOneManifest;
import org.apache.jena.arq.junit.runners.RunnerOneTest;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.junit.EarlReport;
import org.apache.jena.sparql.vocabulary.VocabTestQuery;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public abstract class AbstractRunnerOfTests
extends ParentRunner<Runner> {
    private Description description;
    private List<Runner> children = new ArrayList<Runner>();
    private static boolean PrintManifests = false;
    private static IndentedWriter out = IndentedWriter.stdout;

    public AbstractRunnerOfTests(Class<?> klass, Function<ManifestEntry, Runnable> maker) throws InitializationError {
        super(klass);
        String label = AbstractRunnerOfTests.getLabel(klass);
        if (label == null) {
            label = klass.getName();
        }
        String prefix = AbstractRunnerOfTests.getPrefix(klass);
        String[] manifests = AbstractRunnerOfTests.getManifests(klass);
        if (manifests.length == 0) {
            throw new InitializationError("No manifests");
        }
        this.description = Description.createSuiteDescription((String)label, (Annotation[])new Annotation[0]);
        for (String manifestFile : manifests) {
            if (PrintManifests) {
                out.println("** " + klass.getSimpleName() + " -- " + manifestFile);
                out.incIndent();
            }
            Manifest manifest = Manifest.parse(manifestFile);
            if (PrintManifests) {
                Manifest.walk(manifest, m -> out.println(m.getFileName() + " :: " + m.getName()), e2 -> {});
            }
            RunnerOneManifest runner = AbstractRunnerOfTests.build(null, manifest, maker, prefix);
            this.description.addChild(runner.getDescription());
            this.children.add(runner);
            if (!PrintManifests) continue;
            out.decIndent();
        }
        if (PrintManifests) {
            out.flush();
        }
    }

    public static RunnerOneManifest build(EarlReport report, Manifest manifest, Function<ManifestEntry, Runnable> maker, String prefix) {
        Description description = Description.createSuiteDescription((String)manifest.getName(), (Annotation[])new Annotation[0]);
        if (PrintManifests) {
            out.println(manifest.getFileName() + " :: " + manifest.getName());
        }
        RunnerOneManifest thisLevel = new RunnerOneManifest(manifest, description);
        Iterator<String> sub = manifest.includedManifests();
        while (sub.hasNext()) {
            if (PrintManifests) {
                out.incIndent();
            }
            String mf = sub.next();
            Manifest manifestSub = Manifest.parse(mf);
            RunnerOneManifest runner = AbstractRunnerOfTests.build(report, manifestSub, maker, prefix);
            thisLevel.add(runner);
            if (!PrintManifests) continue;
            out.decIndent();
        }
        manifest.entries().forEach(entry -> {
            if (entry.getAction() == null) {
                throw new RuntimeException("Missing: action [" + entry.getEntry() + "]");
            }
            if (entry.getName() == null) {
                throw new RuntimeException("Missing: label [" + entry.getEntry() + "]");
            }
        });
        AbstractRunnerOfTests.prepareTests(report, thisLevel, manifest, maker, prefix);
        return thisLevel;
    }

    private static String prepareTestLabel(ManifestEntry entry, String prefix) {
        int x;
        Object label = AbstractRunnerOfTests.fixupName(entry.getName());
        if (prefix != null) {
            label = prefix + (String)label;
        }
        String str2 = null;
        if (entry.getAction() != null) {
            Statement stmt;
            if (entry.getAction().isURIResource()) {
                str2 = entry.getAction().getURI();
            } else if (entry.getAction().isAnon() && (stmt = entry.getAction().getProperty(VocabTestQuery.query)) != null && stmt.getObject().isURIResource()) {
                str2 = stmt.getObject().asResource().getURI();
            }
        }
        if (str2 != null && (x = str2.lastIndexOf(47)) > 0 && x < str2.length()) {
            String fn = str2.substring(x + 1);
            label = (String)label + " (" + fn + ")";
        }
        return label;
    }

    public static void prepareTests(EarlReport report, RunnerOneManifest level, Manifest manifest, Function<ManifestEntry, Runnable> maker, String prefix) {
        manifest.entries().forEach(entry -> {
            String label = AbstractRunnerOfTests.prepareTestLabel(entry, prefix);
            Runnable runnable = (Runnable)maker.apply((ManifestEntry)entry);
            if (runnable != null) {
                RunnerOneTest r = new RunnerOneTest(label, runnable, entry.getURI(), report);
                level.add(r);
            }
        });
    }

    public static String fixupName(String string) {
        string = string.replace('(', '[');
        string = string.replace(')', ']');
        return string;
    }

    private static String getLabel(Class<?> klass) {
        Label annotation = klass.getAnnotation(Label.class);
        return annotation == null ? null : annotation.value();
    }

    private static String getPrefix(Class<?> klass) {
        Prefix annotation = klass.getAnnotation(Prefix.class);
        return annotation == null ? null : annotation.value();
    }

    private static String[] getManifests(Class<?> klass) throws InitializationError {
        Manifests annotation = klass.getAnnotation(Manifests.class);
        if (annotation == null) {
            throw new InitializationError(String.format("class '%s' must have a @Manifests annotation", klass.getName()));
        }
        return annotation.value();
    }

    public Description getDescription() {
        return this.description;
    }

    protected List<Runner> getChildren() {
        return this.children;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }
}

