/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.riot;

import java.io.OutputStream;
import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.arq.junit.riot.ParseForTest;
import org.apache.jena.arq.junit.riot.RiotTests;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.IsoMatcher;
import org.junit.Assert;

public class RiotEvalTest
implements Runnable {
    private final boolean expectLegalSyntax;
    private final ManifestEntry testEntry;
    private final Lang lang;
    private final String filename;
    String baseIRI;
    String input;
    String output;

    public RiotEvalTest(ManifestEntry entry, String base, Lang lang, boolean positiveTest) {
        this.testEntry = entry;
        this.expectLegalSyntax = positiveTest;
        this.filename = entry.getAction().getURI();
        this.lang = lang;
        this.baseIRI = base;
        this.input = entry.getAction().getURI();
        this.output = positiveTest ? entry.getResult().getURI() : null;
    }

    @Override
    public void run() {
        if (RDFLanguages.isTriples(this.lang)) {
            this.run3();
        } else {
            this.run4();
        }
    }

    private void run3() {
        block10: {
            Graph graph = GraphFactory.createDefaultGraph();
            StreamRDF dest = StreamRDFLib.graph(graph);
            try {
                if (this.baseIRI != null) {
                    ParseForTest.parse(dest, this.input, this.baseIRI, this.lang, RiotTests.allowWarnings(this.testEntry));
                } else {
                    ParseForTest.parse(dest, this.input, this.lang, RiotTests.allowWarnings(this.testEntry));
                }
                if (!this.expectLegalSyntax) {
                    String fragment = RiotTests.fragment(this.testEntry.getURI());
                    if (fragment != null) {
                        Assert.fail((String)(fragment + ": Passed bad syntax eval test"));
                    } else {
                        Assert.fail((String)"Passed bad syntax eval test");
                    }
                }
                Lang outLang = RDFLanguages.filenameToLang(this.output, Lang.NQUADS);
                Graph results = GraphFactory.createDefaultGraph();
                try {
                    RDFParser.create().errorHandler(ErrorHandlerFactory.errorHandlerNoWarnings).base(this.baseIRI).forceLang(outLang).source(this.output).parse(results);
                }
                catch (RiotException ex) {
                    Assert.fail((String)("Failed to read results: " + ex.getMessage()));
                }
                boolean b = IsoMatcher.isomorphic(graph, results);
                if (!b) {
                    System.out.println("---- Parsed");
                    RDFDataMgr.write((OutputStream)System.out, graph, Lang.TURTLE);
                    System.out.println("---- Expected");
                    RDFDataMgr.write((OutputStream)System.out, results, Lang.TURTLE);
                    System.out.println("--------");
                }
                Assert.assertTrue((String)"Graphs not isomorphic", (boolean)b);
            }
            catch (RiotException ex) {
                if (!this.expectLegalSyntax) break block10;
                throw ex;
            }
        }
    }

    private void run4() {
        block8: {
            DatasetGraph dsg = DatasetGraphFactory.create();
            StreamRDF dest = StreamRDFLib.dataset(dsg);
            try {
                if (this.baseIRI != null) {
                    ParseForTest.parse(dest, this.input, this.baseIRI, this.lang, RiotTests.allowWarnings(this.testEntry));
                } else {
                    ParseForTest.parse(dest, this.input, this.lang, RiotTests.allowWarnings(this.testEntry));
                }
                if (!this.expectLegalSyntax) {
                    Assert.fail((String)"Passed bad syntax eval test");
                }
                Lang outLang = RDFLanguages.filenameToLang(this.output, Lang.NQUADS);
                DatasetGraph results = DatasetGraphFactory.create();
                try {
                    RDFParser.create().errorHandler(ErrorHandlerFactory.errorHandlerNoWarnings).base(this.baseIRI).forceLang(outLang).source(this.output).parse(results);
                }
                catch (RiotException ex) {
                    Assert.fail((String)("Failed to read results: " + ex.getMessage()));
                }
                boolean b = this.isomorphic(dsg, results);
                if (!b) {
                    System.out.println("**** Test: " + this.testEntry.getName());
                    System.out.println("---- Parsed");
                    RDFDataMgr.write((OutputStream)System.out, dsg, Lang.TRIG);
                    System.out.println("---- Expected");
                    RDFDataMgr.write((OutputStream)System.out, results, Lang.TRIG);
                    System.out.println("--------");
                }
                Assert.assertTrue((String)"Datasets not isomorphic", (boolean)b);
            }
            catch (RiotException ex) {
                if (!this.expectLegalSyntax) break block8;
                throw ex;
            }
        }
    }

    private boolean isomorphic(DatasetGraph dsg1, DatasetGraph dsg2) {
        return IsoMatcher.isomorphic(dsg1, dsg2);
    }
}

