/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.riot;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;

public class ParseForTest {
    public static Map<Lang, ReaderRIOTFactory> alternativeReaderFactories = new ConcurrentHashMap<Lang, ReaderRIOTFactory>();

    public static void parse(StreamRDF destination, String uri, Lang lang, boolean ignoreWarnings) {
        ParseForTest.parse(destination, uri, uri, lang, ignoreWarnings);
    }

    public static void parse(StreamRDF destination, String uri, String base, Lang lang, boolean ignoreWarnings) {
        ErrorHandler errorHandlerTest;
        ErrorHandler errorHandler = errorHandlerTest = ignoreWarnings ? ErrorHandlerFactory.errorHandlerIgnoreWarnings(null) : ErrorHandlerFactory.errorHandlerStrictSilent();
        if (alternativeReaderFactories.containsKey(lang)) {
            ReaderRIOTFactory factoryForTest = alternativeReaderFactories.get(lang);
            TypedInputStream in = RDFDataMgr.open(uri);
            ParserProfile profile = RiotLib.profile(lang, base, errorHandlerTest);
            factoryForTest.create(lang, profile).read(in, base, null, destination, RIOT.getContext());
            return;
        }
        RDFParser.create().errorHandler(errorHandlerTest).strict(true).forceLang(lang).source(uri).base(base).build().parse(destination);
    }
}

