/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.deseralization.JsonLdToRdf;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.flattening.NodeMapBuilder;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import jakarta.json.JsonArray;
import java.net.URI;

public final class ToRdfProcessor {
    private ToRdfProcessor() {
    }

    public static final RdfDataset toRdf(URI input, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + input + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return ToRdfProcessor.toRdf(remoteDocument, options);
    }

    public static final RdfDataset toRdf(Document input, JsonLdOptions options) throws JsonLdError {
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setProcessingMode(options.getProcessingMode());
        expansionOptions.setBase(options.getBase());
        expansionOptions.setExpandContext(options.getExpandContext());
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        return JsonLdToRdf.with(NodeMapBuilder.with(expandedInput, new NodeMap()).build(), Rdf.createDataset()).produceGeneralizedRdf(options.isProduceGeneralizedRdf()).rdfDirection(options.getRdfDirection()).build();
    }
}

