/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.NeighborQueue;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;

public class HnswGraphSearcher<T> {
    private final VectorSimilarityFunction similarityFunction;
    private final VectorEncoding vectorEncoding;
    private final NeighborQueue candidates;
    private BitSet visited;

    public HnswGraphSearcher(VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction, NeighborQueue candidates, BitSet visited) {
        this.vectorEncoding = vectorEncoding;
        this.similarityFunction = similarityFunction;
        this.candidates = candidates;
        this.visited = visited;
    }

    public static NeighborQueue search(float[] query2, int topK, RandomAccessVectorValues<float[]> vectors, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction, HnswGraph graph, Bits acceptOrds, int visitedLimit) throws IOException {
        if (query2.length != vectors.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + query2.length + " differs from field dimension: " + vectors.dimension());
        }
        HnswGraphSearcher graphSearcher = new HnswGraphSearcher(vectorEncoding, similarityFunction, new NeighborQueue(topK, true), new SparseFixedBitSet(vectors.size()));
        return HnswGraphSearcher.search(query2, topK, vectors, graph, graphSearcher, acceptOrds, visitedLimit);
    }

    public static NeighborQueue search(float[] query2, int topK, RandomAccessVectorValues<float[]> vectors, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction, OnHeapHnswGraph graph, Bits acceptOrds, int visitedLimit) throws IOException {
        OnHeapHnswGraphSearcher graphSearcher = new OnHeapHnswGraphSearcher(vectorEncoding, similarityFunction, new NeighborQueue(topK, true), new SparseFixedBitSet(vectors.size()));
        return HnswGraphSearcher.search(query2, topK, vectors, graph, graphSearcher, acceptOrds, visitedLimit);
    }

    public static NeighborQueue search(byte[] query2, int topK, RandomAccessVectorValues<byte[]> vectors, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction, HnswGraph graph, Bits acceptOrds, int visitedLimit) throws IOException {
        if (query2.length != vectors.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + query2.length + " differs from field dimension: " + vectors.dimension());
        }
        HnswGraphSearcher graphSearcher = new HnswGraphSearcher(vectorEncoding, similarityFunction, new NeighborQueue(topK, true), new SparseFixedBitSet(vectors.size()));
        return HnswGraphSearcher.search(query2, topK, vectors, graph, graphSearcher, acceptOrds, visitedLimit);
    }

    public static NeighborQueue search(byte[] query2, int topK, RandomAccessVectorValues<byte[]> vectors, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction, OnHeapHnswGraph graph, Bits acceptOrds, int visitedLimit) throws IOException {
        OnHeapHnswGraphSearcher graphSearcher = new OnHeapHnswGraphSearcher(vectorEncoding, similarityFunction, new NeighborQueue(topK, true), new SparseFixedBitSet(vectors.size()));
        return HnswGraphSearcher.search(query2, topK, vectors, graph, graphSearcher, acceptOrds, visitedLimit);
    }

    private static <T> NeighborQueue search(T query2, int topK, RandomAccessVectorValues<T> vectors, HnswGraph graph, HnswGraphSearcher<T> graphSearcher, Bits acceptOrds, int visitedLimit) throws IOException {
        NeighborQueue results;
        int initialEp = graph.entryNode();
        if (initialEp == -1) {
            return new NeighborQueue(1, true);
        }
        int[] eps = new int[]{graph.entryNode()};
        int numVisited = 0;
        for (int level = graph.numLevels() - 1; level >= 1; --level) {
            results = graphSearcher.searchLevel(query2, 1, level, eps, vectors, graph, null, visitedLimit);
            numVisited += results.visitedCount();
            visitedLimit -= results.visitedCount();
            if (results.incomplete()) {
                results.setVisitedCount(numVisited);
                return results;
            }
            eps[0] = results.pop();
        }
        results = graphSearcher.searchLevel(query2, topK, 0, eps, vectors, graph, acceptOrds, visitedLimit);
        results.setVisitedCount(results.visitedCount() + numVisited);
        return results;
    }

    public NeighborQueue searchLevel(T query2, int topK, int level, int[] eps, RandomAccessVectorValues<T> vectors, HnswGraph graph) throws IOException {
        return this.searchLevel(query2, topK, level, eps, vectors, graph, null, Integer.MAX_VALUE);
    }

    private NeighborQueue searchLevel(T query2, int topK, int level, int[] eps, RandomAccessVectorValues<T> vectors, HnswGraph graph, Bits acceptOrds, int visitedLimit) throws IOException {
        float topCandidateSimilarity;
        int size = graph.size();
        NeighborQueue results = new NeighborQueue(topK, false);
        this.prepareScratchState(vectors.size());
        int numVisited = 0;
        for (int ep : eps) {
            if (this.visited.getAndSet(ep)) continue;
            if (numVisited >= visitedLimit) {
                results.markIncomplete();
                break;
            }
            float score = this.compare(query2, vectors, ep);
            ++numVisited;
            this.candidates.add(ep, score);
            if (acceptOrds != null && !acceptOrds.get(ep)) continue;
            results.add(ep, score);
        }
        float minAcceptedSimilarity = Float.NEGATIVE_INFINITY;
        if (results.size() >= topK) {
            minAcceptedSimilarity = results.topScore();
        }
        block1: while (this.candidates.size() > 0 && !results.incomplete() && !((topCandidateSimilarity = this.candidates.topScore()) < minAcceptedSimilarity)) {
            int friendOrd;
            int topCandidateNode = this.candidates.pop();
            this.graphSeek(graph, level, topCandidateNode);
            while ((friendOrd = this.graphNextNeighbor(graph)) != Integer.MAX_VALUE) {
                assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                if (this.visited.getAndSet(friendOrd)) continue;
                if (numVisited >= visitedLimit) {
                    results.markIncomplete();
                    continue block1;
                }
                float friendSimilarity = this.compare(query2, vectors, friendOrd);
                ++numVisited;
                if (!(friendSimilarity >= minAcceptedSimilarity)) continue;
                this.candidates.add(friendOrd, friendSimilarity);
                if (acceptOrds != null && !acceptOrds.get(friendOrd) || !results.insertWithOverflow(friendOrd, friendSimilarity) || results.size() < topK) continue;
                minAcceptedSimilarity = results.topScore();
            }
        }
        while (results.size() > topK) {
            results.pop();
        }
        results.setVisitedCount(numVisited);
        return results;
    }

    private float compare(T query2, RandomAccessVectorValues<T> vectors, int ord) throws IOException {
        if (this.vectorEncoding == VectorEncoding.BYTE) {
            return this.similarityFunction.compare((byte[])query2, (byte[])vectors.vectorValue(ord));
        }
        return this.similarityFunction.compare((float[])query2, (float[])vectors.vectorValue(ord));
    }

    private void prepareScratchState(int capacity) {
        this.candidates.clear();
        if (this.visited.length() < capacity) {
            this.visited = FixedBitSet.ensureCapacity((FixedBitSet)this.visited, capacity);
        }
        this.visited.clear();
    }

    void graphSeek(HnswGraph graph, int level, int targetNode) throws IOException {
        graph.seek(level, targetNode);
    }

    int graphNextNeighbor(HnswGraph graph) throws IOException {
        return graph.nextNeighbor();
    }

    private static class OnHeapHnswGraphSearcher<C>
    extends HnswGraphSearcher<C> {
        private NeighborArray cur;
        private int upto;

        private OnHeapHnswGraphSearcher(VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction, NeighborQueue candidates, BitSet visited) {
            super(vectorEncoding, similarityFunction, candidates, visited);
        }

        @Override
        void graphSeek(HnswGraph graph, int level, int targetNode) {
            this.cur = ((OnHeapHnswGraph)graph).getNeighbors(level, targetNode);
            this.upto = -1;
        }

        @Override
        int graphNextNeighbor(HnswGraph graph) {
            if (++this.upto < this.cur.size()) {
                return this.cur.node[this.upto];
            }
            return Integer.MAX_VALUE;
        }
    }
}

