/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.matchhighlight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.search.matchhighlight.OffsetRange;
import org.apache.lucene.search.matchhighlight.Passage;
import org.apache.lucene.search.matchhighlight.PassageAdjuster;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.PriorityQueue;

public class PassageSelector {
    public static final Comparator<Passage> DEFAULT_SCORER = (a, b) -> {
        int v = Integer.compare(a.markers.size(), b.markers.size());
        if (v != 0) {
            return v;
        }
        int len1 = 0;
        int len2 = 0;
        for (OffsetRange o : a.markers) {
            len1 += o.length();
        }
        for (OffsetRange o : b.markers) {
            len2 += o.length();
        }
        if (len1 != len2) {
            return Integer.compare(len1, len2);
        }
        return Integer.compare(b.from, a.from);
    };
    private final Comparator<Passage> passageScorer;
    private final PassageAdjuster passageAdjuster;

    public PassageSelector() {
        this(DEFAULT_SCORER, null);
    }

    public PassageSelector(Comparator<Passage> passageScorer, PassageAdjuster passageAdjuster) {
        this.passageScorer = passageScorer;
        this.passageAdjuster = passageAdjuster;
    }

    public List<Passage> pickBest(CharSequence value, List<? extends OffsetRange> markers, int maxPassageWindow, int maxPassages) {
        return this.pickBest(value, markers, maxPassageWindow, maxPassages, List.of(new OffsetRange(0, value.length())));
    }

    public List<Passage> pickBest(CharSequence value, List<? extends OffsetRange> markers, int maxPassageWindow, int maxPassages, List<OffsetRange> permittedPassageRanges) {
        Passage[] passages;
        assert (markers instanceof RandomAccess);
        assert (permittedPassageRanges instanceof RandomAccess);
        assert (PassageSelector.sortedAndNonOverlapping(permittedPassageRanges));
        if (value.length() == 0 || maxPassageWindow == 0) {
            return Collections.emptyList();
        }
        int pqSize = Math.max(16, maxPassages);
        PriorityQueue<Passage> pq = new PriorityQueue<Passage>(pqSize){

            @Override
            protected boolean lessThan(Passage a, Passage b) {
                return PassageSelector.this.passageScorer.compare(a, b) < 0;
            }
        };
        markers = this.splitOrTruncateToWindows(markers, maxPassageWindow, permittedPassageRanges);
        markers.sort(Comparator.comparingInt(r -> r.from).thenComparingInt(r -> r.to));
        int max2 = markers.size();
        int markerIndex = 0;
        block0: for (OffsetRange range : permittedPassageRanges) {
            int rangeTo = Math.min(range.to, value.length());
            if (range.from >= rangeTo) continue;
            while (markerIndex < max2) {
                OffsetRange m4 = markers.get(markerIndex);
                if (m4.from >= rangeTo) continue block0;
                if (m4.from >= range.from && m4.to <= rangeTo && m4.length() <= maxPassageWindow) {
                    int from = Math.toIntExact(((long)m4.from + (long)m4.to - (long)maxPassageWindow) / 2L);
                    int to = Math.toIntExact(((long)m4.from + (long)m4.to + (long)maxPassageWindow) / 2L);
                    if (from < range.from) {
                        to += range.from - from;
                        from = range.from;
                    }
                    if (to > rangeTo) {
                        from -= to - rangeTo;
                        to = rangeTo;
                        if (from < range.from) {
                            from = range.from;
                        }
                    }
                    if (from < to && to <= value.length()) {
                        int i;
                        ArrayList<OffsetRange> inside = new ArrayList<OffsetRange>();
                        for (i = markerIndex; i > 0 && markers.get((int)(i - 1)).from >= from; --i) {
                        }
                        while (i < max2) {
                            OffsetRange c = markers.get(i);
                            if (c.from >= to) break;
                            if (c.to <= to) {
                                inside.add(c);
                            }
                            ++i;
                        }
                        if (!inside.isEmpty()) {
                            pq.insertWithOverflow(new Passage(from, to, inside));
                        }
                    }
                }
                ++markerIndex;
            }
        }
        if (pq.size() > 0) {
            passages = new Passage[pq.size()];
            int i = pq.size();
            while (--i >= 0) {
                passages[i] = (Passage)pq.pop();
            }
        } else {
            passages = this.pickDefaultPassage(value, maxPassageWindow, maxPassages, permittedPassageRanges);
        }
        if (this.passageAdjuster != null) {
            this.passageAdjuster.currentValue(value);
            for (int x = 0; x < passages.length; ++x) {
                Passage p = passages[x];
                OffsetRange newRange = this.passageAdjuster.adjust(p);
                if (newRange.from == p.from && newRange.to == p.to) continue;
                assert (newRange.from >= p.from && newRange.to <= p.to) : "Adjusters must not expand the passage's range: was " + p + " => changed to " + newRange;
                passages[x] = new Passage(newRange.from, newRange.to, p.markers);
            }
        }
        int last = 0;
        for (int i = 0; i < passages.length; ++i) {
            Passage a2 = passages[i];
            if (a2 == null || a2.length() <= 0) continue;
            passages[last++] = a2;
            for (int j = i + 1; j < passages.length; ++j) {
                Passage b = passages[j];
                if (b == null || !PassageSelector.adjecentOrOverlapping(a2, b)) continue;
                passages[j] = null;
            }
        }
        if (passages.length != (last = Math.min(last, maxPassages))) {
            passages = ArrayUtil.copyOfSubArray(passages, 0, last);
        }
        Arrays.sort(passages, Comparator.comparingInt(a -> a.from));
        return Arrays.asList(passages);
    }

    private List<? extends OffsetRange> splitOrTruncateToWindows(List<? extends OffsetRange> markers, int maxPassageWindow, List<OffsetRange> permittedPassageRanges) {
        ArrayList<? extends OffsetRange> processedMarkers = new ArrayList<OffsetRange>(markers.size());
        for (OffsetRange offsetRange : markers) {
            for (OffsetRange permitted : permittedPassageRanges) {
                int to;
                boolean newSlice = false;
                int from = offsetRange.from;
                if (from < permitted.from) {
                    from = permitted.from;
                    newSlice = true;
                }
                if ((to = offsetRange.to) > permitted.to) {
                    to = permitted.to;
                    newSlice = true;
                }
                if (from >= to) continue;
                if (to - from > maxPassageWindow) {
                    to = from + maxPassageWindow;
                    newSlice = true;
                }
                processedMarkers.add(newSlice ? offsetRange.slice(from, to) : offsetRange);
            }
        }
        markers = processedMarkers;
        return markers;
    }

    static boolean sortedAndNonOverlapping(List<? extends OffsetRange> permittedPassageRanges) {
        if (permittedPassageRanges.size() > 1) {
            Iterator<? extends OffsetRange> i = permittedPassageRanges.iterator();
            OffsetRange previous = i.next();
            while (i.hasNext()) {
                OffsetRange next = i.next();
                if (previous.to > next.from) {
                    throw new AssertionError((Object)("Ranges must be sorted and non-overlapping: " + permittedPassageRanges));
                }
                previous = next;
            }
        }
        return true;
    }

    protected Passage[] pickDefaultPassage(CharSequence value, int maxCharacterWindow, int maxPassages, List<OffsetRange> permittedPassageRanges) {
        ArrayList<Passage> defaultPassages = new ArrayList<Passage>();
        for (OffsetRange o : permittedPassageRanges) {
            if (defaultPassages.size() >= maxPassages) break;
            int to = Math.min(value.length(), o.to);
            if (o.from >= to) continue;
            defaultPassages.add(new Passage(o.from, o.from + Math.min(maxCharacterWindow, o.length()), Collections.emptyList()));
        }
        return (Passage[])defaultPassages.toArray(Passage[]::new);
    }

    private static boolean adjecentOrOverlapping(Passage a, Passage b) {
        if (a.from >= b.from) {
            return a.from <= b.to - 1;
        }
        return a.to - 1 >= b.from;
    }
}

