/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.lucene90.ForUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.LongHeap;
import org.apache.lucene.util.packed.PackedInts;

final class PForUtil {
    private static final int MAX_EXCEPTIONS = 7;
    private static final int HALF_BLOCK_SIZE = 64;
    private static final long[] IDENTITY_PLUS_ONE = new long[128];
    private final ForUtil forUtil;
    private final byte[] exceptionBuff = new byte[14];

    static boolean allEqual(long[] l) {
        for (int i = 1; i < 128; ++i) {
            if (l[i] == l[0]) continue;
            return false;
        }
        return true;
    }

    PForUtil(ForUtil forUtil) {
        this.forUtil = forUtil;
    }

    void encode(long[] longs, DataOutput out) throws IOException {
        LongHeap top = new LongHeap(8);
        for (int i = 0; i <= 7; ++i) {
            top.push(longs[i]);
        }
        long topValue = top.top();
        for (int i = 8; i < 128; ++i) {
            if (longs[i] <= topValue) continue;
            topValue = top.updateTop(longs[i]);
        }
        long max2 = 0L;
        for (int i = 1; i <= top.size(); ++i) {
            max2 = Math.max(max2, top.get(i));
        }
        int maxBitsRequired = PackedInts.bitsRequired(max2);
        int patchedBitsRequired = Math.max(PackedInts.bitsRequired(topValue), maxBitsRequired - 8);
        int numExceptions = 0;
        long maxUnpatchedValue = (1L << patchedBitsRequired) - 1L;
        for (int i = 2; i <= top.size(); ++i) {
            if (top.get(i) <= maxUnpatchedValue) continue;
            ++numExceptions;
        }
        byte[] exceptions = new byte[numExceptions * 2];
        if (numExceptions > 0) {
            int exceptionCount = 0;
            for (int i = 0; i < 128; ++i) {
                if (longs[i] <= maxUnpatchedValue) continue;
                exceptions[exceptionCount * 2] = (byte)i;
                exceptions[exceptionCount * 2 + 1] = (byte)(longs[i] >>> patchedBitsRequired);
                int n = i;
                longs[n] = longs[n] & maxUnpatchedValue;
                ++exceptionCount;
            }
            assert (exceptionCount == numExceptions) : exceptionCount + " " + numExceptions;
        }
        if (PForUtil.allEqual(longs) && maxBitsRequired <= 8) {
            for (int i = 0; i < numExceptions; ++i) {
                exceptions[2 * i + 1] = (byte)(Byte.toUnsignedLong(exceptions[2 * i + 1]) << patchedBitsRequired);
            }
            out.writeByte((byte)(numExceptions << 5));
            out.writeVLong(longs[0]);
        } else {
            int token = numExceptions << 5 | patchedBitsRequired;
            out.writeByte((byte)token);
            this.forUtil.encode(longs, patchedBitsRequired, out);
        }
        out.writeBytes(exceptions, exceptions.length);
    }

    void decode(DataInput in, long[] longs) throws IOException {
        int token = Byte.toUnsignedInt(in.readByte());
        int bitsPerValue = token & 0x1F;
        int numExceptions = token >>> 5;
        if (bitsPerValue == 0) {
            Arrays.fill(longs, 0, 128, in.readVLong());
        } else {
            this.forUtil.decode(bitsPerValue, in, longs);
        }
        for (int i = 0; i < numExceptions; ++i) {
            int n = Byte.toUnsignedInt(in.readByte());
            longs[n] = longs[n] | Byte.toUnsignedLong(in.readByte()) << bitsPerValue;
        }
    }

    void decodeAndPrefixSum(DataInput in, long base, long[] longs) throws IOException {
        int token = Byte.toUnsignedInt(in.readByte());
        int bitsPerValue = token & 0x1F;
        int numExceptions = token >>> 5;
        if (numExceptions == 0) {
            if (bitsPerValue == 0) {
                long val = in.readVLong();
                if (val == 1L) {
                    PForUtil.prefixSumOfOnes(longs, base);
                } else {
                    PForUtil.prefixSumOf(longs, base, val);
                }
            } else {
                this.forUtil.decodeTo32(bitsPerValue, in, longs);
                PForUtil.prefixSum32(longs, base);
            }
        } else {
            if (bitsPerValue == 0) {
                PForUtil.fillSameValue32(longs, in.readVLong());
            } else {
                this.forUtil.decodeTo32(bitsPerValue, in, longs);
            }
            this.applyExceptions32(bitsPerValue, numExceptions, in, longs);
            PForUtil.prefixSum32(longs, base);
        }
    }

    void skip(DataInput in) throws IOException {
        int token = Byte.toUnsignedInt(in.readByte());
        int bitsPerValue = token & 0x1F;
        int numExceptions = token >>> 5;
        if (bitsPerValue == 0) {
            in.readVLong();
            in.skipBytes(numExceptions << 1);
        } else {
            in.skipBytes(this.forUtil.numBytes(bitsPerValue) + (numExceptions << 1));
        }
    }

    private static void prefixSumOfOnes(long[] longs, long base) {
        System.arraycopy(IDENTITY_PLUS_ONE, 0, longs, 0, 128);
        int i = 0;
        while (i < 128) {
            int n = i++;
            longs[n] = longs[n] + base;
        }
    }

    private static void prefixSumOf(long[] longs, long base, long val) {
        for (int i = 0; i < 128; ++i) {
            longs[i] = (long)(i + 1) * val + base;
        }
    }

    private static void fillSameValue32(long[] longs, long val) {
        long token = val << 32 | val;
        Arrays.fill(longs, 0, 64, token);
    }

    private void applyExceptions32(int bitsPerValue, int numExceptions, DataInput in, long[] longs) throws IOException {
        in.readBytes(this.exceptionBuff, 0, numExceptions * 2);
        for (int i = 0; i < numExceptions; ++i) {
            int exceptionPos = Byte.toUnsignedInt(this.exceptionBuff[i * 2]);
            long exception = Byte.toUnsignedLong(this.exceptionBuff[i * 2 + 1]);
            int idx = exceptionPos & 0x3F;
            int shift = bitsPerValue + ((1 ^ exceptionPos >>> 6) << 5);
            int n = idx;
            longs[n] = longs[n] | exception << shift;
        }
    }

    private static void prefixSum32(long[] longs, long base) {
        longs[0] = longs[0] + (base << 32);
        PForUtil.innerPrefixSum32(longs);
        PForUtil.expand32(longs);
        long l = longs[63];
        int i = 64;
        while (i < 128) {
            int n = i++;
            longs[n] = longs[n] + l;
        }
    }

    private static void expand32(long[] longs) {
        for (int i = 0; i < 64; ++i) {
            long l = longs[i];
            longs[i] = l >>> 32;
            longs[64 + i] = l & 0xFFFFFFFFL;
        }
    }

    private static void innerPrefixSum32(long[] longs) {
        longs[1] = longs[1] + longs[0];
        longs[2] = longs[2] + longs[1];
        longs[3] = longs[3] + longs[2];
        longs[4] = longs[4] + longs[3];
        longs[5] = longs[5] + longs[4];
        longs[6] = longs[6] + longs[5];
        longs[7] = longs[7] + longs[6];
        longs[8] = longs[8] + longs[7];
        longs[9] = longs[9] + longs[8];
        longs[10] = longs[10] + longs[9];
        longs[11] = longs[11] + longs[10];
        longs[12] = longs[12] + longs[11];
        longs[13] = longs[13] + longs[12];
        longs[14] = longs[14] + longs[13];
        longs[15] = longs[15] + longs[14];
        longs[16] = longs[16] + longs[15];
        longs[17] = longs[17] + longs[16];
        longs[18] = longs[18] + longs[17];
        longs[19] = longs[19] + longs[18];
        longs[20] = longs[20] + longs[19];
        longs[21] = longs[21] + longs[20];
        longs[22] = longs[22] + longs[21];
        longs[23] = longs[23] + longs[22];
        longs[24] = longs[24] + longs[23];
        longs[25] = longs[25] + longs[24];
        longs[26] = longs[26] + longs[25];
        longs[27] = longs[27] + longs[26];
        longs[28] = longs[28] + longs[27];
        longs[29] = longs[29] + longs[28];
        longs[30] = longs[30] + longs[29];
        longs[31] = longs[31] + longs[30];
        longs[32] = longs[32] + longs[31];
        longs[33] = longs[33] + longs[32];
        longs[34] = longs[34] + longs[33];
        longs[35] = longs[35] + longs[34];
        longs[36] = longs[36] + longs[35];
        longs[37] = longs[37] + longs[36];
        longs[38] = longs[38] + longs[37];
        longs[39] = longs[39] + longs[38];
        longs[40] = longs[40] + longs[39];
        longs[41] = longs[41] + longs[40];
        longs[42] = longs[42] + longs[41];
        longs[43] = longs[43] + longs[42];
        longs[44] = longs[44] + longs[43];
        longs[45] = longs[45] + longs[44];
        longs[46] = longs[46] + longs[45];
        longs[47] = longs[47] + longs[46];
        longs[48] = longs[48] + longs[47];
        longs[49] = longs[49] + longs[48];
        longs[50] = longs[50] + longs[49];
        longs[51] = longs[51] + longs[50];
        longs[52] = longs[52] + longs[51];
        longs[53] = longs[53] + longs[52];
        longs[54] = longs[54] + longs[53];
        longs[55] = longs[55] + longs[54];
        longs[56] = longs[56] + longs[55];
        longs[57] = longs[57] + longs[56];
        longs[58] = longs[58] + longs[57];
        longs[59] = longs[59] + longs[58];
        longs[60] = longs[60] + longs[59];
        longs[61] = longs[61] + longs[60];
        longs[62] = longs[62] + longs[61];
        longs[63] = longs[63] + longs[62];
    }

    static {
        for (int i = 0; i < 128; ++i) {
            PForUtil.IDENTITY_PLUS_ONE[i] = i + 1;
        }
    }
}

