/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.solver;

import java.util.function.Predicate;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Graph;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.main.StageGenerator;
import org.apache.jena.tdb.solver.PatternMatchTDB1;
import org.apache.jena.tdb.solver.QC2;
import org.apache.jena.tdb.store.GraphTDB;
import org.apache.jena.tdb.store.NodeId;

public class StageGeneratorDirectTDB
implements StageGenerator {
    StageGenerator above = null;

    public StageGeneratorDirectTDB(StageGenerator original) {
        this.above = original;
    }

    @Override
    public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        Graph g2 = execCxt.getActiveGraph();
        if (!(g2 instanceof GraphTDB)) {
            return this.above.execute(pattern, input, execCxt);
        }
        GraphTDB graph = (GraphTDB)g2;
        Predicate<Tuple<NodeId>> filter = QC2.getFilter(execCxt.getContext());
        return PatternMatchTDB1.execute(graph, pattern, input, filter, execCxt);
    }
}

